/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.Theme;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00072\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006J4\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0014\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u0007J@\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/docops/asciidoc/buttons/ButtonMaker;", "", "()V", "startLegendHeight", "", "types", "", "", "getTypes", "()Ljava/util/Map;", "buttonTypes", "buttons", "", "Lio/docops/asciidoc/buttons/models/Button;", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "drawLegend", "height", "heightFactor", "defaultHeight", "makeButtons", "makeDefs", "makeSvgEnd", "makeSvgHead", "widthFactor", "docops-button-render"})
public abstract class ButtonMaker {
    @NotNull
    private final Map<String, String> types = new LinkedHashMap();
    private int startLegendHeight;

    @NotNull
    public abstract String makeButtons(@NotNull List<List<Button>> var1, @NotNull Theme var2);

    @NotNull
    protected final Map<String, String> getTypes() {
        return this.types;
    }

    private final int height(List<List<Button>> buttons, int heightFactor, int defaultHeight, Theme theme) {
        int height = defaultHeight;
        if (buttons.size() > 1) {
            height = heightFactor * buttons.size();
        }
        if (theme.getLegendOn()) {
            this.startLegendHeight = height + 30;
            Map<String, String> unique = this.buttonTypes(buttons, theme);
            height += 20 * unique.size();
            height += 20;
        }
        return height;
    }

    private final Map<String, String> buttonTypes(List<List<Button>> buttons, Theme theme) {
        Iterable $this$forEach$iv = buttons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = it;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Button btn = (Button)element$iv2;
                boolean bl2 = false;
                this.types.put(theme.buttonColor(btn), btn.getType());
            }
        }
        return this.types;
    }

    @NotNull
    public final String makeSvgHead(@NotNull List<List<Button>> buttons, int heightFactor, int defaultHeight, int widthFactor, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        int height = this.height(buttons, heightFactor, defaultHeight, theme);
        int maxWidth = theme.getColumns() * widthFactor + theme.getColumns() * 10;
        return "<?xml version=\"1.0\" standalone=\"no\"?>\n                <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + maxWidth + "\" height=\"" + (height + 20) + "\"\n                xmlns:xlink=\"http://www.w3.org/1999/xlink\" viewBox=\"0 0 " + maxWidth + ' ' + (height + 20) + "\"\n                >";
    }

    public static /* synthetic */ String makeSvgHead$default(ButtonMaker buttonMaker, List list, int n, int n2, int n3, Theme theme, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeSvgHead");
        }
        if ((n4 & 2) != 0) {
            n = 170;
        }
        if ((n4 & 4) != 0) {
            n2 = 250;
        }
        if ((n4 & 8) != 0) {
            n3 = 100;
        }
        return buttonMaker.makeSvgHead(list, n, n2, n3, theme);
    }

    @NotNull
    public final String makeDefs(@NotNull Theme theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        return "\n        <defs>\n        <filter id=\"dropShadow\" height=\"112%\">\n            <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"1\"/>\n            <feOffset dx=\"1\" dy=\"3\" result=\"offsetblur\"/>\n            <feComponentTransfer>\n                <feFuncA type=\"linear\" slope=\"0." + theme.getDropShadow() + "\"/>\n            </feComponentTransfer>\n            <feMerge>\n                <feMergeNode/>\n                <feMergeNode in=\"SourceGraphic\"/>\n            </feMerge>\n        </filter>\n        <filter id=\"filter\">\n            <feMorphology in=\"SourceAlpha\" operator=\"dilate\" radius=\"2\" result=\"OUTLINE\"/>\n            <feComposite operator=\"out\" in=\"OUTLINE\" in2=\"SourceAlpha\"/>\n        </filter>\n        <linearGradient id=\"linear-gradient-0\" gradientUnits=\"userSpaceOnUse\" x1=\"162.375\" y1=\"40.053\" x2=\"162.375\" y2=\"9.99\">\n            <stop offset=\"0\" stop-color=\"#ff857a\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#f0a2b7\" stop-opacity=\"1\"/>\n        </linearGradient>\n        <linearGradient id=\"linear-gradient-1\" gradientUnits=\"userSpaceOnUse\" x1=\"471.482\" y1=\"39.988\" x2=\"471.482\" y2=\"9.983\">\n            <stop offset=\"0\" stop-color=\"#ffa801\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#ffcc01\" stop-opacity=\"1\"/>\n        </linearGradient>\n        <linearGradient id=\"linear-gradient-2\" gradientUnits=\"userSpaceOnUse\" x1=\"781.482\" y1=\"39.988\" x2=\"781.482\" y2=\"9.983\">\n            <stop offset=\"0\" stop-color=\"#cb43f6\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#ec4cbd\" stop-opacity=\"1\"/>\n        </linearGradient>\n        <linearGradient id=\"linear-gradient-3\" gradientUnits=\"userSpaceOnUse\" x1=\"162.375\" y1=\"80.053\" x2=\"162.375\" y2=\"49.99\">\n            <stop offset=\"0\" stop-color=\"#ff857a\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#f0a2b7\" stop-opacity=\"1\"/>\n        </linearGradient>\n        <linearGradient id=\"linear-gradient-4\" gradientUnits=\"userSpaceOnUse\" x1=\"471.482\" y1=\"79.988\" x2=\"471.482\"\n                        y2=\"49.983\">\n            <stop offset=\"0\" stop-color=\"#ffa801\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#ffcc01\" stop-opacity=\"1\"/>\n        </linearGradient>\n        <linearGradient id=\"linear-gradient-5\" gradientUnits=\"userSpaceOnUse\" x1=\"781.482\" y1=\"79.988\" x2=\"781.482\" y2=\"49.983\">\n            <stop offset=\"0\" stop-color=\"#cb43f6\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#ec4cbd\" stop-opacity=\"1\"/>\n        </linearGradient>\n        <circle id=\"myCircle\" cx=\"0\" cy=\"0\"  r=\"60\" class=\"card\"/>\n        <rect id=\"legendRect\" x=\"0\" y=\"0\" width=\"10\" height=\"10\"  class=\"legend\"/>\n        <rect id=\"mySlimRect\" x=\"0\" y=\"0\" width=\"150\" height=\"150\" rx=\"5\" ry=\"5\" class=\"card\"/>\n        <rect id=\"myLargeRect\" fill=\"#fffefa\" x=\"0\" y=\"0\" width=\"300\" height=\"400\" rx=\"5\" ry=\"5\" class=\"card\" filter=\"url(#dropShadow)\">\n            <title class=\"description\"/>\n        </rect>\n        <rect id=\"myLargerHeroRect\" x=\"0\" y=\"0\" width=\"300\" height=\"191\" rx=\"5\" ry=\"5\" class=\"card\"/>\n        <rect id=\"myPanel\" x=\"0\" y=\"0\" width=\"300\" height=\"30\" rx=\"5\" ry=\"5\" class=\"card\"/>\n        " + theme.getDefs() + "\n    </defs>\n    ";
    }

    @NotNull
    public final String makeSvgEnd() {
        return "</svg>";
    }

    @NotNull
    public final String drawLegend(@NotNull Map<String, String> types) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        StringBuilder sb = new StringBuilder("<svg>");
        String recXpos = null;
        recXpos = "10";
        String textXPos = null;
        textXPos = "30";
        int yPos = 0;
        yPos = this.startLegendHeight - 20;
        int size = types.size() / 2;
        int count = 0;
        Map<String, String> $this$forEach$iv = types;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String color = entry.getKey();
            String desc = entry.getValue();
            if (count == size) {
                recXpos = "50%";
                yPos = this.startLegendHeight - 20;
                textXPos = "54%";
            }
            sb.append(StringsKt.trimIndent((String)("\n                <use x=\"" + recXpos + "\" y=\"" + yPos + "\" style=\"fill:" + color + "\" class=\"card\" xlink:href=\"#legendRect\"/>\n                <text x=\"" + textXPos + "\" y=\"" + (yPos + 10) + "\" class=\"legendText\">" + desc + "</text>\n            ")));
            yPos += 20;
            ++count;
        }
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }
}

