/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.ButtonMaker;
import io.docops.asciidoc.buttons.dsl.Font;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.models.ButtonImage;
import io.docops.asciidoc.buttons.theme.Theme;
import io.docops.asciidoc.utils.StringFunctionsKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u0010\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002JD\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lio/docops/asciidoc/buttons/LargeCard;", "Lio/docops/asciidoc/buttons/ButtonMaker;", "()V", "drawButtonRow", "", "rowCount", "", "row", "", "Lio/docops/asciidoc/buttons/models/Button;", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "drawButtons", "buttonList", "makeButtons", "buttons", "makeStyles", "makeTwoTone", "x", "y", "line1", "line2", "color", "button", "docops-button-render"})
public final class LargeCard
extends ButtonMaker {
    @Override
    @NotNull
    public String makeButtons(@NotNull List<List<Button>> buttons, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        StringBuilder sb = new StringBuilder(this.makeSvgHead(buttons, 410, 500, 310, theme));
        sb.append(this.makeDefs(theme));
        sb.append(this.makeStyles(buttons, theme));
        sb.append(this.drawButtons(buttons, theme));
        if (theme.getLegendOn()) {
            sb.append(this.drawLegend(this.getTypes()));
        }
        sb.append(this.makeSvgEnd());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtons(List<List<Button>> buttonList, Theme theme) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = buttonList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void buttons;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            sb.append(this.drawButtonRow(index, (List<Button>)buttons, theme));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtonRow(int rowCount, List<Button> row, Theme theme) {
        StringBuilder sb = new StringBuilder("<svg>");
        int recXpos = 0;
        recXpos = 10;
        int yPos = 0;
        yPos = 10;
        int dateXpos = 0;
        dateXpos = 95;
        if (rowCount > 0) {
            yPos = rowCount * 410 + 10;
        }
        Iterable $this$forEachIndexed$iv = row;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void button;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Button button2 = (Button)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                recXpos += 320;
                dateXpos += 320;
            }
            String win = !theme.getNewWin() ? "_top" : "_blank";
            List<StringBuilder> lines = StringFunctionsKt.addLinebreaks(button.getDescription(), 41);
            String imgOrRec = null;
            imgOrRec = "";
            if (button.getButtonImage() != null) {
                ButtonImage it;
                boolean bl2 = false;
                imgOrRec = "data:" + it.getType() + ";base64," + it.getRef();
            }
            if (button.getButtonImage() != null) {
                ButtonImage img = button.getButtonImage();
                if (img != null) {
                    boolean bl3 = false;
                    imgOrRec = StringsKt.trimIndent((String)("\n                        <use x=\"" + recXpos + "\" y=\"" + yPos + "\" class=\"card\" fill=\"" + theme.buttonColor((Button)button) + "\" xlink:href=\"#myLargerHeroRect\"/>\n                        <image x=\"" + recXpos + "\" y=\"" + yPos + "\" width=\"300\" height=\"191\" href=\"" + img.getRef() + "\"/>"));
                }
            } else {
                imgOrRec = StringsKt.trimIndent((String)("\n                    <use x=\"" + recXpos + "\" y=\"" + yPos + "\" class=\"card\" fill=\"" + theme.buttonColor((Button)button) + "\" xlink:href=\"#myLargerHeroRect\"/>\n                    "));
                if (button.getLine1() != null && button.getLine2() != null) {
                    imgOrRec = imgOrRec + this.makeTwoTone(recXpos, yPos, button.getLine1(), button.getLine2(), theme.buttonColor((Button)button), (Button)button, theme);
                }
            }
            if (theme.isPDF()) {
                sb.append(StringsKt.trimIndent((String)("\n                   <use x=\"" + recXpos + "\" y=\"" + yPos + "\" class=\"card\" xlink:href=\"#myLargeRect\"><title class=\"description\">" + StringFunctionsKt.escapeXml(button.getDescription()) + "</title></use>     \n                   " + imgOrRec + "\n                ")));
            } else {
                sb.append(StringsKt.trimIndent((String)("\n                    <a xlink:href=\"" + button.getLink() + "\" target=\"" + win + "\">\n                    <use x=\"" + recXpos + "\" y=\"" + yPos + "\" class=\"card\" xlink:href=\"#myLargeRect\"><title class=\"description\">" + StringFunctionsKt.escapeXml(button.getDescription()) + "</title></use>    \n                   " + imgOrRec + "\n                   </a>\n                ")));
            }
            StringBuilder authors = new StringBuilder();
            Object $this$forEach$iv = button.getAuthors();
            boolean $i$f$forEach = false;
            Iterator bl3 = $this$forEach$iv.iterator();
            while (bl3.hasNext()) {
                Object element$iv = bl3.next();
                String it = (String)element$iv;
                boolean bl4 = false;
                authors.append("<tspan x=\"" + (recXpos + 10) + "\" dy=\"18\" class=\"author\">" + StringFunctionsKt.escapeXml(it) + "</tspan>");
            }
            if (theme.isPDF()) {
                sb.append(StringsKt.trimIndent((String)("\n                        <tspan class=\"title\" text-decoration=\"underline\" fill=\"#335D79\">" + StringFunctionsKt.escapeXml(button.getTitle()) + "</tspan>\n                        <text x=\"" + (recXpos + 10) + "\" y=\"" + (yPos + 220) + "\" class=\"category\">" + StringFunctionsKt.escapeXml(button.getType()) + "</text>\n                        <text x=\"" + (recXpos + 10) + "\" y=\"" + (yPos + 240) + "\" class=\"longdesc\">\n                    ")));
            } else {
                $this$forEach$iv = new StringBuilder();
                ((StringBuilder)$this$forEach$iv).append("\n                        <text x=\"").append(recXpos + 10).append("\" y=\"").append(yPos + 220).append("\" class=\"link\">\n                            <a href=\"").append(button.getLink()).append("\" class=\"title ").append(theme.buttonTextColor((Button)button)).append("\">\n                                ").append(StringFunctionsKt.escapeXml(button.getTitle())).append("\n                            </a>\n                        </text>\n                        <text x=\"").append(recXpos + 10).append("\" y=\"").append(yPos + 238).append("\" class=\"category ").append(theme.buttonTextColor((Button)button)).append("\">").append(StringFunctionsKt.escapeXml(button.getType())).append("</text>\n                        <text x=\"").append(recXpos + 10).append("\" y=\"").append(yPos + 240).append("\" class=\"longdesc\">\n                    ");
                sb.append(StringsKt.trimIndent((String)((StringBuilder)$this$forEach$iv).toString()));
            }
            sb.append(((Object)StringsKt.trimEnd((CharSequence)("\n                    " + authors + "\n                    <tspan x=\"" + (recXpos + 10) + "\" dy=\"18\" class=\"date\">" + StringFunctionsKt.escapeXml(button.getDate()) + "</tspan>\n            "))).toString());
            Iterable $this$forEachIndexed$iv2 = lines;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void str;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                StringBuilder stringBuilder = (StringBuilder)item$iv2;
                int i = n2;
                boolean bl5 = false;
                if (i >= 6) continue;
                StringBuilder stringBuilder2 = new StringBuilder().append("\n                <tspan x=\"").append(recXpos + 10).append("\" dy=\"18\" class=\"longdesc\">");
                String string = str.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.toString()");
                sb.append(StringsKt.trimIndent((String)stringBuilder2.append(StringFunctionsKt.escapeXml(string)).append("</tspan>\n                ").toString()));
            }
            sb.append("</text>");
        }
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String makeStyles(List<List<Button>> buttonList, Theme theme) {
        Iterable $this$forEach$iv = buttonList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List buttons = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = buttons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Button item = (Button)element$iv2;
                boolean bl2 = false;
                theme.buttonTextColor(item);
            }
        }
        String str = null;
        str = "    <style>\nrect.card {\n    pointer-events: bounding-box;\n    opacity: 1;\n}\nrect.card:hover {\n    opacity: 0.6;\n}\nuse.card {\n    pointer-events: bounding-box;\n    opacity: 1;\n}\nuse.card:hover {\n    opacity: 0.6;\n}\n.card {\n    pointer-events: bounding-box;\n    opacity: 1;\n}\n.card:hover {\n    opacity: 0.6;\n}\n.headline {\n    font-family:  Helvetica, Arial, sans-serif;\n    fill: #46494d;\n}\n.link {\nfont-family:  Helvetica, Arial, sans-serif;\n    fill: #335D79;\n}\n.description {\n    font-size: 9pt;\n    font-family:  Helvetica, Arial, sans-serif;    \n}\n.category {\n    font-size: 10pt;\n    font-family:  Helvetica, Arial, sans-serif;    \n}\n.longdesc {\n    font-family:  Helvetica, Arial, sans-serif;     \n    font-size: 9pt;\n}\n.legendText {\n    font-size: 9pt;\n    font-family:  Helvetica, Arial, sans-serif;    \n}\n";
        Map<String, String> $this$forEach$iv3 = theme.getButtonStyleMap();
        boolean $i$f$forEach3 = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String t = entry.getKey();
            String u = entry.getValue();
            str = str + '.' + u + " {" + t + "}\n";
        }
        str = str + "</style>";
        return str;
    }

    private final String makeTwoTone(int x, int y, String line1, String line2, String color, Button button, Theme theme) {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String guid = string;
        Object font = null;
        font = "Arial, Helvetica, sans-serif";
        if (button.getFont() != null) {
            Object object = button.getFont();
            if (object != null && (object = ((Font)object).getFamily()) != null) {
                Object it = object;
                boolean bl = false;
                font = it;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n            <svg id=\"twotone").append(guid).append("\" x=\"").append(x).append("\" y=\"").append(y).append("\" width=\"300px\" height=\"191px\" viewBox=\"0 0 300 191\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n                <title>ICON</title>\n                <desc></desc>\n                <style>\n                    .oddstyle").append(guid).append(" {\n                        font: bold 60px ").append((String)font).append(";\n                        fill: ").append(color).append(";\n                    }\n\n                    .evenstyle").append(guid).append(" {\n                        font: bold 60px ").append((String)font).append(";\n                        fill: #ffffff;\n                    }\n                </style>\n                <g id=\"Page-1").append(guid).append("\" stroke=\"none\" stroke-width=\"1\" fill=\"#FFFFFF\">\n                    <rect width=\"100%\" height=\"100%\" fill=\"none\" />\n                    <rect width=\"100%\" height=\"50%\" fill=\"#FFFFFF\"/>\n                    <rect y=\"95.5\" width=\"100%\" height=\"50%\" fill=\"").append(color).append("\" />\n                    <text text-anchor=\"middle\" x=\"150\" y=\"67.75\" class=\"oddstyle").append(guid).append("\">");
        stringBuilder.append(line1).append("</text>\n                    <text text-anchor=\"middle\" x=\"150\" y=\"163.25\" class=\"evenstyle").append(guid).append("\">").append(line2).append("</text>\n                </g>\n            </svg>\n        ");
        return StringsKt.trimIndent((String)stringBuilder.toString());
    }
}

