/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.ButtonMaker;
import io.docops.asciidoc.buttons.dsl.Link;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.models.ButtonImage;
import io.docops.asciidoc.buttons.theme.Theme;
import io.docops.asciidoc.utils.StringFunctionsKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J(\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J$\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J0\u0010\u0017\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J$\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/docops/asciidoc/buttons/RectangleCardRenderer;", "Lio/docops/asciidoc/buttons/ButtonMaker;", "()V", "spacer", "", "createDefs", "", "buttons", "", "Lio/docops/asciidoc/buttons/models/Button;", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "createItem", "button", "row", "column", "itemIndex", "makeButtonImage", "x", "y", "makeButtons", "makeLinks", "window", "makeNumberedButtonImage", "makeStyles", "buttonList", "docops-button-render"})
public final class RectangleCardRenderer
extends ButtonMaker {
    private int spacer = 15;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String makeButtons(@NotNull List<List<Button>> buttons, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        theme.setLegendOn(false);
        StringBuilder sb = new StringBuilder(this.makeSvgHead(buttons, 135, 110, 300, theme));
        sb.append("\n    " + this.makeStyles(buttons, theme) + "\n    " + this.createDefs(buttons, theme) + "\n    ");
        int row = 0;
        int column = 0;
        int count = 0;
        Iterable $this$forEachIndexed$iv = buttons;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void btns;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv2 = (Iterable)btns;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void item;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Button button = (Button)item$iv2;
                int current = n2;
                boolean bl2 = false;
                int n3 = count;
                count = n3 + 1;
                sb.append(this.createItem((Button)item, row, column, theme, n3));
                ++column;
            }
            ++row;
            column = 0;
        }
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String makeStyles(List<List<Button>> buttonList, Theme theme) {
        Iterable $this$forEach$iv = buttonList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List buttons = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = buttons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Button item = (Button)element$iv2;
                boolean bl2 = false;
                theme.buttonTextColor(item);
            }
        }
        String str = null;
        str = StringsKt.trimIndent((String)("\n        <style>\n        .myrect {\n            filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0." + theme.getDropShadow() + "));  \n            stroke: #d2ddec;\n        }\n\n        .linkText {\n            fill: #4076ff;\n            font-size: 15px;\n            font-family: \"Inter var\", system-ui, \"Helvetica Neue\", Helvetica, Arial, sans-serif;\n            font-weight: normal;\n            cursor: pointer;\n        }\n        .linkText:hover {\n            fill: #ea0606;\n            border: #d2ddec solid;\n        }\n\n\n"));
        Map<String, String> $this$forEach$iv3 = theme.getButtonStyleMap();
        boolean $i$f$forEach3 = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String t = entry.getKey();
            String u = entry.getValue();
            str = str + '.' + u + " {" + t + "}\n";
        }
        str = str + "</style>";
        return str;
    }

    private final String createItem(Button button, int row, int column, Theme theme, int itemIndex) {
        String window = "_top";
        if (theme.getNewWin()) {
            window = "_blank";
        }
        int rowHeight = 120;
        int itemHeight = rowHeight * row + 10 + row * this.spacer;
        int width = 293;
        int itemWidth = column * width + 10 + this.spacer * column;
        String contentBox = button.getButtonImage() != null ? this.makeButtonImage(button, itemWidth + 12, itemHeight + 15, itemIndex) : this.makeNumberedButtonImage(button, itemWidth + 12, itemHeight + 15, itemIndex, window);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n        <g>\n        <rect x=\"").append(itemWidth).append("\" y=\"").append(itemHeight).append("\" width=\"").append(width).append("\" class=\"myrect\" height=\"").append(rowHeight).append("\" rx=\"12\" ry=\"12\" fill=\"#ffffff\" fill-opacity='0.3'/>\n        <a xlink:href=\"").append(button.getLink()).append("\" class=\"linkText\" target=\"").append(window).append("\">\n        <text x=\"").append(itemWidth + 15 + 105).append("\" y=\"").append(itemHeight + 25).append("\" class=\"").append(theme.buttonTextColor(button)).append("\">").append(StringFunctionsKt.escapeXml(button.getTitle())).append("</text>\n        </a>\n        <a xlink:href=\"").append(button.getLink()).append("\" class=\"linkText\" target=\"");
        stringBuilder.append(window).append("\">\n        <rect x=\"").append(itemWidth + 10).append("\" y=\"").append(itemHeight + 10).append("\" height=\"98\" width=\"98\" rx=\"12\" ry=\"12\" fill=\"").append(theme.buttonColor(button)).append("\"/>\n        </a>\n        ").append(contentBox).append("\n        ").append(this.makeLinks(itemWidth + 15 + 105, itemHeight + 30, button, window)).append("\n        </g>\n        ");
        return StringsKt.trimIndent((String)stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    private final String makeLinks(int x, int y, Button button, String window) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringsKt.trimIndent((String)("<text x=\"" + x + "\" y=\"" + y + "\">")));
        int downBy = 0;
        downBy = 16;
        List<Link> list = button.getLinks();
        if (list != null) {
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void link;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Link link2 = (Link)item$iv;
                int index = n;
                boolean bl = false;
                if (index > 0) {
                    downBy = 20;
                }
                sb.append("<tspan  x=\"" + x + "\" dy=\"" + downBy + "\"><a xlink:href=\"" + link.getHref() + "\" class=\"linkText\" target=\"" + window + "\">" + link.getLabel() + "</a></tspan>");
            }
        }
        sb.append("</text>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String makeButtonImage(Button button, int x, int y, int itemIndex) {
        ButtonImage buttonImage = button.getButtonImage();
        if (buttonImage != null) {
            ButtonImage it = buttonImage;
            boolean bl = false;
            ButtonImage buttonImage2 = button.getButtonImage();
            return StringsKt.trimIndent((String)("\n            <image x=\"" + (x + 10) + "\" y=\"" + (y + 9) + "\" width=\"75\" height=\"75\" href=\"" + (buttonImage2 != null ? buttonImage2.getRef() : null) + "\"/>\n        "));
        }
        return "";
    }

    private final String makeNumberedButtonImage(Button button, int x, int y, int itemIndex, String window) {
        return StringsKt.trimIndent((String)("\n            <g>\n                <style>\n                    #numberedIcon {\n                       font-family: Helvetica,sans-serif;\n                       fill: #ffffff;\n                       font-size: 60px;\n                       dominant-baseline: central;\n                       text-anchor: middle;\n                   }\n                </style>\n                <rect x=\"" + (x - 2) + "\" y=\"" + (y - 4) + "\" height=\"98\" width=\"98\" fill=\"none\"/>\n                <text id=\"numberedIcon\" x=\"" + (x + 49) + "\" y=\"" + (y + 49) + "\" ><a xlink:href=\"" + button.getLink() + "\" target=\"" + window + "\">" + (itemIndex + 1) + "</a></text>\n            </g>\n        "));
    }

    private final String createDefs(List<List<Button>> buttons, Theme theme) {
        return "<defs/>";
    }
}

