/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.ButtonMaker;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.Theme;
import io.docops.asciidoc.utils.StringFunctionsKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u000f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lio/docops/asciidoc/buttons/RoundButtonItemRenderer;", "Lio/docops/asciidoc/buttons/ButtonMaker;", "()V", "drawButtonRow", "", "rowCount", "", "buttons", "", "Lio/docops/asciidoc/buttons/models/Button;", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "drawButtons", "buttonList", "makeButtons", "makeStyles", "docops-button-render"})
public final class RoundButtonItemRenderer
extends ButtonMaker {
    @Override
    @NotNull
    public String makeButtons(@NotNull List<List<Button>> buttons, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        StringBuilder sb = new StringBuilder(this.makeSvgHead(buttons, 155, 130, 140, theme));
        sb.append(this.makeDefs(theme));
        sb.append(this.makeStyles(buttons, theme));
        sb.append(this.drawButtons(buttons, theme));
        if (theme.getLegendOn()) {
            sb.append(this.drawLegend(this.getTypes()));
        }
        sb.append(this.makeSvgEnd());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtons(List<List<Button>> buttonList, Theme theme) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = buttonList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void buttons;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            sb.append(this.drawButtonRow(index, (List<Button>)buttons, theme));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtonRow(int rowCount, List<Button> buttons, Theme theme) {
        StringBuilder sb = new StringBuilder("<g>");
        int recXpos = 0;
        recXpos = 80;
        int yPos = 0;
        yPos = 65;
        if (rowCount > 0) {
            yPos = rowCount * 130 + 65;
        }
        int textXPos = 0;
        textXPos = 55;
        Iterable $this$forEachIndexed$iv = buttons;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String str;
            int i;
            int n;
            int index$iv2;
            boolean $i$f$forEachIndexed2;
            Iterable $this$forEachIndexed$iv2;
            int dy;
            List<String> lines;
            void button;
            String win;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Button button2 = (Button)item$iv;
            int index = n2;
            boolean bl = false;
            if (index > 0) {
                recXpos += 125;
                textXPos += 115;
            }
            String string = win = !theme.getNewWin() ? "_top" : "_blank";
            if (theme.isPDF()) {
                sb.append(StringsKt.trimIndent((String)("\n                   <use x=\"" + recXpos + "\" y=\"" + yPos + "\" xlink:href=\"#myCircle\" fill=\"" + theme.buttonColor((Button)button) + "\">\n                        <title class=\"description\">" + StringFunctionsKt.escapeXml(button.getDescription()) + "</title>\n                   </use>\n                   <text class=\"category\" visibility=\"hidden\">" + StringFunctionsKt.escapeXml(button.getType()) + "</text>\n                   <text class=\"author\" visibility=\"hidden\">" + (String)CollectionsKt.firstOrNull(button.getAuthors()) + "</text>\n                   <text class=\"date\" visibility=\"hidden\">" + StringFunctionsKt.escapeXml(button.getDate()) + "</text>\n                ")));
                sb.append("\n                <text x=\"" + recXpos + "\" y=\"" + (yPos + 5) + "\" text-anchor=\"middle\" class=\"label " + theme.buttonTextColor((Button)button) + "\">");
                lines = StringFunctionsKt.makeLines(button.getTitle());
                dy = 0;
                if (lines.size() > 2) {
                    dy = -10 * (lines.size() - 2);
                }
                $this$forEachIndexed$iv2 = lines;
                $i$f$forEachIndexed2 = false;
                index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    if ((n = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string2 = (String)item$iv2;
                    i = n;
                    boolean bl2 = false;
                    if (i > 0) {
                        dy = 12;
                    }
                    sb.append("<tspan class=\"title\" x=\"" + recXpos + "\" dy=\"" + dy + "\">" + StringFunctionsKt.escapeXml(str) + "</tspan>");
                }
                sb.append("</text>");
                continue;
            }
            sb.append(StringsKt.trimIndent((String)("\n                   <a xlink:href=\"" + button.getLink() + "\" target=\"" + win + "\">\n                       <use x=\"" + recXpos + "\" y=\"" + yPos + "\" xlink:href=\"#myCircle\" class=\"card\" fill=\"" + theme.buttonColor((Button)button) + "\">\n                           <title class=\"description\">" + StringFunctionsKt.escapeXml(button.getDescription()) + "</title>\n                       </use>\n                       <text class=\"category\" visibility=\"hidden\">" + StringFunctionsKt.escapeXml(button.getType()) + "</text>\n                       <text class=\"author\" visibility=\"hidden\">" + (String)CollectionsKt.firstOrNull(button.getAuthors()) + "</text>\n                       <text class=\"date\" visibility=\"hidden\">" + StringFunctionsKt.escapeXml(button.getDate()) + "</text>\n                   </a>\n                ")));
            sb.append(" \n                <a xlink:href=\"" + button.getLink() + "\" target=\"" + win + "\">\n                    <text x=\"" + recXpos + "\" y=\"" + (yPos + 5) + "\" text-anchor=\"middle\" >");
            lines = StringFunctionsKt.makeLines(button.getTitle());
            dy = 0;
            if (lines.size() > 2) {
                dy = -10 * (lines.size() - 2);
            }
            $this$forEachIndexed$iv2 = lines;
            $i$f$forEachIndexed2 = false;
            index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                if ((n = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                str = (String)item$iv2;
                i = n;
                boolean bl3 = false;
                if (i > 0) {
                    dy = 12;
                }
                sb.append("<tspan class=\"title " + theme.buttonTextColor((Button)button) + "\" x=\"" + recXpos + "\" dy=\"" + dy + "\">" + StringFunctionsKt.escapeXml(str) + "</tspan>");
            }
            sb.append("</text>\n</a>");
        }
        sb.append("</g>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String makeStyles(List<List<Button>> buttonList, Theme theme) {
        Iterable $this$forEach$iv = buttonList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List buttons = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = buttons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Button item = (Button)element$iv2;
                boolean bl2 = false;
                theme.buttonTextColor(item);
            }
        }
        String str = null;
        str = StringsKt.trimIndent((String)("\n        <style>\n        circle.card {\n            filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0." + theme.getDropShadow() + ")); \n            pointer-events: bounding-box;\n            opacity: 1;\n        }\n        circle.card:hover {\n            opacity: 0.6;\n        }\n        use.card {\n            filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0." + theme.getDropShadow() + "));\n            pointer-events: bounding-box;\n            opacity: 1;\n        }\n        use.card:hover {\n            opacity: 0.6;\n        }\n        .subtitle {\n            font-family: Helvetica, Arial, sans-serif;\n            font-weight: normal;\n            font-size: 9pt;\n        }\n        rect.legend {\n            pointer-events: bounding-box;\n            opacity: 1;\n        }\n\n        rect.legend:hover {\n            opacity: 0.6;\n        }\n        .label {\n            font-family: Helvetica, Arial, sans-serif;\n            font-size: 9pt;\n        }\n        .legendText {\n            font-size: 9pt;\n            font-family:  Helvetica, Arial, sans-serif;    \n        }\n        \n    "));
        Map<String, String> $this$forEach$iv3 = theme.getButtonStyleMap();
        boolean $i$f$forEach3 = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String t = entry.getKey();
            String u = entry.getValue();
            str = str + '.' + u + " {" + t + "}\n";
        }
        str = str + "</style>";
        return str;
    }
}

