/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons.service;

import io.docops.asciidoc.buttons.ButtonRenderImpl;
import io.docops.asciidoc.buttons.dsl.ButtonItem;
import io.docops.asciidoc.buttons.dsl.Font;
import io.docops.asciidoc.buttons.dsl.LargeButton;
import io.docops.asciidoc.buttons.dsl.Link;
import io.docops.asciidoc.buttons.dsl.PanelButton;
import io.docops.asciidoc.buttons.dsl.Panels;
import io.docops.asciidoc.buttons.dsl.RectangleButton;
import io.docops.asciidoc.buttons.dsl.RoundButton;
import io.docops.asciidoc.buttons.dsl.SlimButton;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.models.ButtonImage;
import io.docops.asciidoc.buttons.theme.ButtonType;
import io.docops.asciidoc.buttons.theme.Theme;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u000fJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lio/docops/asciidoc/buttons/service/PanelService;", "", "()V", "determineFont", "Lio/docops/asciidoc/buttons/dsl/Font;", "panel", "Lio/docops/asciidoc/buttons/dsl/Panels;", "pb", "Lio/docops/asciidoc/buttons/dsl/ButtonItem;", "extractButtonList", "", "Lio/docops/asciidoc/buttons/models/Button;", "extractThemeFromPanel", "Lio/docops/asciidoc/buttons/theme/Theme;", "fromPanelToSvg", "", "toLines", "filename", "panels", "server", "toPanelForPdfLinks", "docops-button-render"})
public final class PanelService {
    @NotNull
    public final String fromPanelToSvg(@NotNull Panels panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Theme theme = this.extractThemeFromPanel(panel);
        List<Button> localList = this.extractButtonList(panel);
        ButtonRenderImpl b = new ButtonRenderImpl();
        return b.render(localList, theme);
    }

    private final List<Button> extractButtonList(Panels panel) {
        List localList = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$0[panel.getButtonType().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = panel.getPanelButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PanelButton it = (PanelButton)element$iv;
                    boolean bl = false;
                    Font f = this.determineFont(panel, it);
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), it.getAuthors(), it.getLabel(), it.getDate(), f, null, null, null, null, null, 3968, null);
                    localList.add(btn);
                }
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = panel.getSlimButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SlimButton it = (SlimButton)element$iv;
                    boolean bl = false;
                    Font f = this.determineFont(panel, it);
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), it.getAuthors(), it.getType(), it.getDate(), f, null, null, null, null, null, 3968, null);
                    localList.add(btn);
                }
                break;
            }
            case 3: {
                Iterable $this$forEach$iv = panel.getLargeButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LargeButton it = (LargeButton)element$iv;
                    boolean bl = false;
                    Font f = this.determineFont(panel, it);
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), it.getAuthors(), it.getType(), it.getDate(), f, null, null, it.getButtonImage(), it.getLine1(), it.getLine2(), 384, null);
                    localList.add(btn);
                }
                break;
            }
            case 4: {
                Iterable $this$forEach$iv = panel.getRoundButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RoundButton it = (RoundButton)element$iv;
                    boolean bl = false;
                    Font f = this.determineFont(panel, it);
                    Button btn = new Button(it.getLabel(), it.getLink(), it.getDescription(), it.getAuthors(), it.getLabel(), "", f, null, null, null, null, null, 3968, null);
                    localList.add(btn);
                }
                break;
            }
            case 5: {
                Iterable $this$forEach$iv = panel.getRectangleButtons();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RectangleButton it = (RectangleButton)element$iv;
                    boolean bl = false;
                    Font f = this.determineFont(panel, it);
                    String string = it.getLabel();
                    String string2 = it.getLink();
                    String string3 = it.getDescription();
                    List<String> list = it.getAuthors();
                    String string4 = it.getLabel();
                    List<Link> list2 = it.getLinks();
                    ButtonImage buttonImage = it.getButtonImage();
                    Button btn = new Button(string, string2, string3, list, string4, "", f, null, list2, buttonImage, null, null, 3200, null);
                    localList.add(btn);
                }
                break;
            }
        }
        return localList;
    }

    private final Theme extractThemeFromPanel(Panels panel) {
        Theme theme;
        block1: {
            theme = new Theme();
            theme.setType(panel.getButtonType());
            theme.setGroupBy(panel.getButtonTheme().getLayout().getGroupBy());
            theme.setGroupOrder(panel.getButtonTheme().getLayout().getGroupOrder());
            theme.setColumns(panel.getButtonTheme().getLayout().getColumns());
            if (!((Collection)panel.getButtonTheme().getColorMap().getColors()).isEmpty()) {
                theme.setColorMap(new ArrayList());
                theme.getColorMap().addAll((Collection<String>)panel.getButtonTheme().getColorMap().getColors());
            }
            theme.setDefs(panel.getButtonTheme().getColorMap().getColorDefs());
            theme.setPDF(panel.isPdf());
            theme.setLegendOn(panel.getButtonTheme().getLegendOn());
            theme.setNewWin(panel.getButtonTheme().getNewWin());
            theme.setDropShadow(panel.getButtonTheme().getDropShadow());
            Font font = panel.getButtonTheme().getFont();
            if (font == null) break block1;
            Font it = font;
            boolean bl = false;
            theme.setFont(it);
        }
        return theme;
    }

    private final Font determineFont(Panels panel, ButtonItem pb) {
        Font f = panel.getButtonTheme().getFont();
        if (pb.getFont() != null) {
            f = pb.getFont();
        }
        return f;
    }

    @NotNull
    public final List<String> toLines(@NotNull String filename, @NotNull Panels panels, @NotNull String server) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)panels, (String)"panels");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Theme theme = this.extractThemeFromPanel(panels);
        List<Button> buttons = this.extractButtonList(panels);
        List lines = new ArrayList();
        lines.add('.' + filename);
        lines.add("[options=header]");
        lines.add("|===");
        lines.add("| |Label |Link");
        Iterable $this$forEach$iv = buttons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Button it = (Button)element$iv;
            boolean bl = false;
            lines.add("a|image::" + server + "/api/panel/pancolor?color=" + URLEncoder.encode(theme.buttonColor(it), "utf-8") + "&label=" + URLEncoder.encode(it.getTitle(), "utf-8") + "&fname=abc.svg[] a|" + it.getTitle() + " a|link:[" + it.getTitle() + ']');
            List<Link> list = it.getLinks();
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Link item = (Link)element$iv2;
                boolean bl2 = false;
                lines.add(" 3+a| link:" + item.getHref() + '[' + item.getLabel() + ']');
            }
        }
        lines.add("|===");
        return lines;
    }

    private final List<ButtonItem> toPanelForPdfLinks(Panels panel) {
        List localList = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$0[panel.getButtonType().ordinal()]) {
            case 1: {
                localList.addAll((Collection)panel.getPanelButtons());
                break;
            }
            case 2: {
                localList.addAll((Collection)panel.getSlimButtons());
                break;
            }
            case 3: {
                localList.addAll((Collection)panel.getLargeButtons());
                break;
            }
            case 4: {
                localList.addAll((Collection)panel.getRoundButtons());
                break;
            }
            case 5: {
                localList.addAll((Collection)panel.getRectangleButtons());
            }
        }
        return localList;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ButtonType.values().length];
            try {
                nArray[ButtonType.BUTTON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ButtonType.SLIM_CARD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ButtonType.LARGE_CARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ButtonType.ROUND.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ButtonType.RECTANGLE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

