/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons.theme;

import io.docops.asciidoc.buttons.dsl.Case;
import io.docops.asciidoc.buttons.dsl.Font;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.ButtonType;
import io.docops.asciidoc.buttons.theme.Grouping;
import io.docops.asciidoc.buttons.theme.GroupingOrder;
import io.docops.asciidoc.buttons.theme.ThemeDSL;
import io.docops.asciidoc.utils.StringFunctionsKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ThemeDSL
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 Q2\u00020\u0001:\u0001QB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\u00020\u00052\u0006\u0010I\u001a\u00020JJ\u0011\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0005H\u0086\u0004J\r\u0010O\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bPR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0016R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00105\"\u0004\b:\u00107R\u001a\u0010;\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00105\"\u0004\b=\u00107R\u001a\u0010>\u001a\u00020?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR&\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u0007\"\u0004\bF\u0010G\u00a8\u0006R"}, d2={"Lio/docops/asciidoc/buttons/theme/Theme;", "", "()V", "buttonStyleMap", "", "", "getButtonStyleMap", "()Ljava/util/Map;", "colorMap", "", "getColorMap", "()Ljava/util/List;", "setColorMap", "(Ljava/util/List;)V", "columns", "", "getColumns", "()I", "setColumns", "(I)V", "defs", "getDefs", "()Ljava/lang/String;", "setDefs", "(Ljava/lang/String;)V", "dropShadow", "getDropShadow", "setDropShadow", "font", "Lio/docops/asciidoc/buttons/dsl/Font;", "getFont", "()Lio/docops/asciidoc/buttons/dsl/Font;", "setFont", "(Lio/docops/asciidoc/buttons/dsl/Font;)V", "fontWeight", "getFontWeight", "setFontWeight", "groupBy", "Lio/docops/asciidoc/buttons/theme/Grouping;", "getGroupBy", "()Lio/docops/asciidoc/buttons/theme/Grouping;", "setGroupBy", "(Lio/docops/asciidoc/buttons/theme/Grouping;)V", "groupOrder", "Lio/docops/asciidoc/buttons/theme/GroupingOrder;", "getGroupOrder", "()Lio/docops/asciidoc/buttons/theme/GroupingOrder;", "setGroupOrder", "(Lio/docops/asciidoc/buttons/theme/GroupingOrder;)V", "guid", "getGuid", "isPDF", "", "()Z", "setPDF", "(Z)V", "legendOn", "getLegendOn", "setLegendOn", "newWin", "getNewWin", "setNewWin", "type", "Lio/docops/asciidoc/buttons/theme/ButtonType;", "getType", "()Lio/docops/asciidoc/buttons/theme/ButtonType;", "setType", "(Lio/docops/asciidoc/buttons/theme/ButtonType;)V", "typeMap", "getTypeMap", "setTypeMap", "(Ljava/util/Map;)V", "buttonColor", "button", "Lio/docops/asciidoc/buttons/models/Button;", "buttonTextColor", "typeIs", "", "other", "validate", "validate$docops_button_render", "Companion", "docops-button-render"})
public final class Theme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int columns = 3;
    @NotNull
    private final String guid;
    @NotNull
    private List<String> colorMap;
    @NotNull
    private Grouping groupBy;
    @NotNull
    private GroupingOrder groupOrder;
    @NotNull
    private String fontWeight;
    @NotNull
    private ButtonType type;
    private boolean newWin;
    private boolean legendOn;
    private boolean isPDF;
    @NotNull
    private String defs;
    private int dropShadow;
    @NotNull
    private Font font;
    @NotNull
    private Map<String, String> typeMap;
    @NotNull
    private final Map<String, String> buttonStyleMap;
    @NotNull
    private static final List<String> fontWeights;

    public Theme() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.guid = string;
        Object[] objectArray = new String[]{"#DA79EC", "#DECD5E", "#F6AB4C", "#F8827D", "#FB0F5F", "#ED4661", "#7FA0BC", "#74F78F", "#EBFB01", "#1EB20B", "#06A69F", "#E33241", "#E21A0E", "#CAF728", "#CEFF48", "#F62A0C", "#2913ED", "#324DE5", "#32B0A1", "#1EB178"};
        this.colorMap = CollectionsKt.mutableListOf((Object[])objectArray);
        this.groupBy = Grouping.ORDER;
        this.groupOrder = GroupingOrder.ASCENDING;
        this.fontWeight = "normal";
        this.type = ButtonType.BUTTON;
        this.newWin = true;
        this.defs = "";
        this.dropShadow = 1;
        this.font = new Font();
        this.typeMap = new LinkedHashMap();
        this.buttonStyleMap = new LinkedHashMap();
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int n) {
        this.columns = n;
    }

    @NotNull
    public final String getGuid() {
        return this.guid;
    }

    @NotNull
    public final List<String> getColorMap() {
        return this.colorMap;
    }

    public final void setColorMap(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colorMap = list;
    }

    @NotNull
    public final Grouping getGroupBy() {
        return this.groupBy;
    }

    public final void setGroupBy(@NotNull Grouping grouping) {
        Intrinsics.checkNotNullParameter((Object)((Object)grouping), (String)"<set-?>");
        this.groupBy = grouping;
    }

    @NotNull
    public final GroupingOrder getGroupOrder() {
        return this.groupOrder;
    }

    public final void setGroupOrder(@NotNull GroupingOrder groupingOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)groupingOrder), (String)"<set-?>");
        this.groupOrder = groupingOrder;
    }

    @NotNull
    public final String getFontWeight() {
        return this.fontWeight;
    }

    public final void setFontWeight(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fontWeight = string;
    }

    @NotNull
    public final ButtonType getType() {
        return this.type;
    }

    public final void setType(@NotNull ButtonType buttonType) {
        Intrinsics.checkNotNullParameter((Object)((Object)buttonType), (String)"<set-?>");
        this.type = buttonType;
    }

    public final boolean getNewWin() {
        return this.newWin;
    }

    public final void setNewWin(boolean bl) {
        this.newWin = bl;
    }

    public final boolean getLegendOn() {
        return this.legendOn;
    }

    public final void setLegendOn(boolean bl) {
        this.legendOn = bl;
    }

    public final boolean isPDF() {
        return this.isPDF;
    }

    public final void setPDF(boolean bl) {
        this.isPDF = bl;
    }

    @NotNull
    public final String getDefs() {
        return this.defs;
    }

    public final void setDefs(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defs = string;
    }

    public final int getDropShadow() {
        return this.dropShadow;
    }

    public final void setDropShadow(int n) {
        this.dropShadow = n;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    public final void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
        this.font = font;
    }

    @NotNull
    public final Map<String, String> getTypeMap() {
        return this.typeMap;
    }

    public final void setTypeMap(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.typeMap = map;
    }

    @NotNull
    public final Map<String, String> getButtonStyleMap() {
        return this.buttonStyleMap;
    }

    public final void typeIs(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.type = ButtonType.valueOf(other);
    }

    @NotNull
    public final Theme validate$docops_button_render() {
        if (!fontWeights.contains(this.fontWeight)) {
            boolean $i$a$-require-Theme$validate$32 = false;
            String $i$a$-require-Theme$validate$32 = "not a valid font weight " + this.fontWeight;
            throw new IllegalArgumentException($i$a$-require-Theme$validate$32.toString());
        }
        int n = this.dropShadow;
        if (!(0 <= n ? n < 10 : false)) {
            boolean bl = false;
            String string = "dropShadow value " + this.dropShadow + " does not fall in the range 0..9";
            throw new IllegalArgumentException(string.toString());
        }
        return this;
    }

    @NotNull
    public final String buttonColor(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        String color = null;
        color = "";
        String string = button.getBackgroundColor();
        if (string != null) {
            String it = string;
            boolean bl = false;
            color = it;
        }
        String col = this.typeMap.get(button.getType());
        if (col == null && ((CharSequence)color).length() == 0) {
            color = this.colorMap.get(this.typeMap.size() % this.colorMap.size());
            this.typeMap.put(button.getType(), color);
        } else if (col != null) {
            color = col;
        }
        return color;
    }

    @NotNull
    public final String buttonTextColor(@NotNull Button button) {
        String string;
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Font f = button.getFont();
        if (f == null) {
            f = this.font;
        }
        String style = null;
        style = "";
        Font it = f;
        boolean bl = false;
        if (((CharSequence)it.getFamily()).length() > 0) {
            style = style + "font-family:" + StringFunctionsKt.escapeXml(it.getFamily()) + ';';
        }
        if (((CharSequence)it.getSize()).length() > 0) {
            style = style + "font-size:" + it.getSize() + ';';
        }
        if (((CharSequence)it.getColor()).length() > 0) {
            style = style + "fill:" + it.getColor() + ';';
        }
        if (((CharSequence)it.getSpacing()).length() > 0) {
            style = style + "letter-spacing:" + it.getSpacing() + ';';
        }
        if (it.getBold()) {
            style = style + "font-weight:bold;";
        }
        if (it.getItalic()) {
            style = style + "font-style:italic;";
        }
        if (it.getUnderline()) {
            style = style + "text-decoration:underline;";
        }
        if (it.getVertical()) {
            style = style + "writing-mode:vertical-rl;";
        }
        StringBuilder stringBuilder = new StringBuilder().append(style);
        switch (WhenMappings.$EnumSwitchMapping$0[it.getCase().ordinal()]) {
            case 1: {
                string = "text-transform:capitalize;";
                break;
            }
            case 2: {
                string = "text-transform:uppercase;";
                break;
            }
            case 3: {
                string = "text-transform:lowercase;";
                break;
            }
            case 4: {
                string = "font-variant:small-caps;";
                break;
            }
            default: {
                string = "";
            }
        }
        style = stringBuilder.append(string).toString();
        String clazz = "";
        if (this.buttonStyleMap.get(style) == null) {
            clazz = "btnclass" + (this.buttonStyleMap.size() + 1) + this.guid;
            this.buttonStyleMap.put(style, clazz);
        } else {
            String string2 = this.buttonStyleMap.get(style);
            Intrinsics.checkNotNull((Object)string2);
            clazz = string2;
        }
        style = "style=\"" + style + '\"';
        return clazz;
    }

    static {
        Object[] objectArray = new String[]{"bold", "normal", "italic"};
        fontWeights = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/docops/asciidoc/buttons/theme/Theme$Companion;", "", "()V", "fontWeights", "", "", "docops-button-render"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Case.values().length];
            try {
                nArray[Case.CAPITALIZE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Case.UPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Case.LOWER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Case.SMALLCAPS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

