/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.stackbar;

import io.docops.asciidoc.stackbar.model.StackModel;
import io.docops.asciidoc.utils.StringFunctionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0007H\u0002J\u001c\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\nH\u0002J&\u0010\u001c\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00062\u0006\u0010\u001f\u001a\u00020\u00072\b\b\u0002\u0010 \u001a\u00020\u0003J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00102\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0006H\u0002J\b\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0003H\u0002J\"\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010&\u001a\u00020\u00072\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0006R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lio/docops/asciidoc/stackbar/StackedBarMaker;", "", "pdf", "", "(Z)V", "colorMap", "", "", "colorRange", "", "", "getColorRange", "()Ljava/util/Map;", "setColorRange", "(Ljava/util/Map;)V", "colors", "", "getColors", "()Ljava/util/List;", "setColors", "(Ljava/util/List;)V", "getPdf", "()Z", "defs", "end", "head", "height", "width", "makeStackedBar", "stackModels", "Lio/docops/asciidoc/stackbar/model/StackModel;", "title", "darkMode", "normalize", "", "script", "style", "toLine", "filename", "list", "docops-button-render"})
public final class StackedBarMaker {
    private final boolean pdf;
    @NotNull
    private List<String> colorMap;
    @NotNull
    private List<String> colors;
    @NotNull
    private Map<Integer, ? extends List<String>> colorRange;

    public StackedBarMaker(boolean pdf) {
        this.pdf = pdf;
        Object[] objectArray = new String[]{"#093145", "#107896", "#829356", "#0C374D", "#1287A8", "#93A661", "#C2571A", "#9A2617", "#D3B53D", "#DA621E", "#AD2A1A", "#EBC944", "#F26D21", "#C02F1D", "#0D3D56", "#1496BB", "#A3B86C", "#3C6478", "#43ABC9", "#B5C689", "#BCA136", "#EFD469", "#F58B4C", "#CD594A"};
        this.colorMap = CollectionsKt.listOf((Object[])objectArray);
        this.colors = new ArrayList();
        objectArray = new Pair[4];
        Object[] objectArray2 = new String[]{"#deaddf", "#e8e08e", "#e7d2ae", "#97dfd2", "#9efdc1", "#f3e76f", "#a7cbda", "#ef8ce3", "#6ed7ed", "#d9b8a2", "#e9ce86", "#dac588", "#fae587", "#56f1e2", "#8fbeef", "#d8b5e3", "#cba2f8", "#cf7bf3", "#ead471", "#d3e58f"};
        objectArray[0] = TuplesKt.to((Object)1, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"#b9deae", "#c8bbe5", "#8baeea", "#65cef4", "#d7f640", "#ddfc65", "#ece2a7", "#f1a9b2", "#abc2f0", "#ed9ecb", "#f588d0", "#f1d692", "#ec8af0", "#fc64f3", "#7ecbe6", "#78e9c9", "#61f3fc", "#a197e7", "#a9dcbd", "#a7ef7d"};
        objectArray[1] = TuplesKt.to((Object)2, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"#ecc4b9", "#e2c5c3", "#e69cf0", "#eab2bc", "#b7b1e0", "#cff24e", "#cfe8c1", "#8cd6f4", "#e9aecb", "#a7d3be", "#ed8bc9", "#69d5eb", "#f3a0c4", "#f4c99f", "#96b6fd", "#f356ec", "#aec0ec", "#aac7e5", "#9291fa", "#aff8b5"};
        objectArray[2] = TuplesKt.to((Object)3, (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"#efd17b", "#7fd4d7", "#dd9ad6", "#fbdb80", "#e2d1ad", "#e0e878", "#e7b2c5", "#e579cb", "#e9b392", "#e1b0ce", "#c5e885", "#48d6f6", "#e0b4e3", "#bcfc7a", "#db78dc", "#b6f3c3", "#d397c7", "#f8a9aa", "#72a7fb", "#81cdd8"};
        objectArray[3] = TuplesKt.to((Object)4, (Object)CollectionsKt.listOf((Object[])objectArray2));
        this.colorRange = MapsKt.mapOf((Pair[])objectArray);
    }

    public /* synthetic */ StackedBarMaker(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getPdf() {
        return this.pdf;
    }

    @NotNull
    public final List<String> getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    @NotNull
    public final Map<Integer, List<String>> getColorRange() {
        return this.colorRange;
    }

    public final void setColorRange(@NotNull Map<Integer, ? extends List<String>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.colorRange = map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeStackedBar(@NotNull List<StackModel> stackModels, @NotNull String title, boolean darkMode) {
        Intrinsics.checkNotNullParameter(stackModels, (String)"stackModels");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        int i = RangesKt.random((IntRange)new IntRange(1, 4), (Random)((Random)Random.Default));
        List<String> list = this.colorRange.get(i);
        Intrinsics.checkNotNull(list);
        this.colors = CollectionsKt.toMutableList((Collection)list);
        int barWidth = 40;
        StringBuilder sb = new StringBuilder();
        int width = 800;
        sb.append(this.head(460, width));
        sb.append(this.defs());
        sb.append(this.style(darkMode));
        if (!this.pdf) {
            sb.append(this.script());
        }
        List<Double> norm = this.normalize(stackModels);
        double totalHeight = 0.0;
        totalHeight = 20.0;
        double x = (double)width * 0.1;
        String mode = "#eeeeee";
        if (darkMode) {
            mode = "#444444";
        }
        String fill = null;
        fill = "#000000";
        if (darkMode) {
            fill = "#ffffff";
        }
        sb.append(StringsKt.trimIndent((String)("\n               <rect x=\"0\" y=\"0\" rx=\"5\" ry=\"5\" fill=\"" + mode + "\" height=\"95%\" width=\"95%\" class=\"outerbox\"/>\n               <text x=\"" + width / 2 + "\" y=\"24\" text-anchor=\"middle\" class=\"title\">" + title + "</text>\n            ")));
        Iterable $this$forEachIndexed$iv = stackModels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void stackModel;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StackModel stackModel2 = (StackModel)item$iv;
            int index = n;
            boolean bl = false;
            double height = (double)400 * ((Number)norm.get(index)).doubleValue();
            double nextHalf = height / (double)2 + totalHeight;
            sb.append("<rect x=\"" + x + "\" y=\"" + totalHeight + "\" width=\"" + barWidth + "\" height=\"" + height + "\" fill=\"" + this.colors.get(index % this.colors.size()) + "\" class=\"card\" onmouseover=\"show('rect-" + index + "');\" onmouseout=\"hide('rect-" + index + "');\"/>");
            sb.append("<text x=\"" + (x + (double)20) + "\" y=\"" + nextHalf + "\" text-anchor=\"middle\" class=\"label\" onmouseover=\"show('rect-" + index + "');\" onmouseout=\"hide('rect-" + index + "');\">" + MathKt.roundToInt((double)(((Number)norm.get(index)).doubleValue() * (double)100)) + "%</text>");
            sb.append("<line x1=\"" + (x + (double)40) + "\" y1=\"" + nextHalf + "\" x2=\"" + (x + (double)90) + "\" y2=\"" + nextHalf + "\" style=\"stroke-width: 2; stroke: " + this.colors.get(index % this.colors.size()) + ";\" marker-end=\"url(#arrowhead)\"/>");
            List<StringBuilder> lines = StringFunctionsKt.addLinebreaks(stackModel.getDescription(), 50);
            sb.append("\n                <text x=\"" + (x + (double)102) + "\" y=\"" + nextHalf + "\" class=\"desc\">");
            int start = 0;
            start = 3;
            if (lines.size() > 1) {
                start = -2;
            }
            Iterable $this$forEachIndexed$iv2 = lines;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void line;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                StringBuilder stringBuilder = (StringBuilder)item$iv2;
                int i2 = n2;
                boolean bl2 = false;
                if (i2 > 0) {
                    start = 12;
                }
                sb.append("<tspan x =\"" + (x + (double)102) + "\" dy = \"" + start + "\">" + line + "</tspan>");
            }
            sb.append("</text>");
            if (!this.pdf) {
                List<StringBuilder> desc = StringFunctionsKt.addLinebreaks(stackModel.getFullDescription(), 50);
                sb.append("<text x=\"400\" y=\"80\" visibility=\"hidden\" id=\"rect-" + index + "\" class=\"desc\">");
                Iterable $this$forEachIndexed$iv3 = desc;
                boolean $i$f$forEachIndexed3 = false;
                int index$iv3 = 0;
                for (Object item$iv3 : $this$forEachIndexed$iv3) {
                    void d;
                    int n3;
                    if ((n3 = index$iv3++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    StringBuilder i2 = (StringBuilder)item$iv3;
                    int i3 = n3;
                    boolean bl3 = false;
                    start = i3 == 0 ? 0 : 12;
                    sb.append("<tspan x=\"410\" dy=\"" + start + "\" fill=\"" + fill + "\">" + d + "</tspan>");
                }
                sb.append("</text>");
            }
            totalHeight += height;
        }
        sb.append(this.end());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String makeStackedBar$default(StackedBarMaker stackedBarMaker, List list, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return stackedBarMaker.makeStackedBar(list, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> normalize(List<StackModel> stackModels) {
        List values = new ArrayList();
        Iterable iterable = stackModels;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            StackModel stackModel = (StackModel)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getValue();
            d = d2 + d3;
        }
        double sum = d;
        Iterable $this$forEach$iv = stackModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackModel it = (StackModel)element$iv;
            boolean bl = false;
            values.add(it.getValue() / sum);
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> toLine(@NotNull String filename, @NotNull List<StackModel> list) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        List<Double> norm = this.normalize(list);
        List lines = new ArrayList();
        lines.add('.' + filename);
        lines.add("[cols=\"15%,15%,20%, 50%\", options=header]");
        lines.add("|===");
        lines.add("|Percent |Value |Label |Description");
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void stackModel;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StackModel stackModel2 = (StackModel)item$iv;
            int index = n;
            boolean bl = false;
            lines.add("" + '|' + MathKt.roundToInt((double)(((Number)norm.get(index)).doubleValue() * (double)100)) + " % |" + stackModel.getValue() + " |" + stackModel.getDescription() + " |" + stackModel.getFullDescription());
        }
        lines.add("|===");
        return lines;
    }

    private final String head(int height, int width) {
        return StringsKt.trimIndent((String)("\n            <?xml version='1.0'?>\n            <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + width + "\" height=\"" + height + "\"\n            viewBox=\"0 0 " + (width + 20) + ' ' + (height + 20) + "\">\n        "));
    }

    static /* synthetic */ String head$default(StackedBarMaker stackedBarMaker, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 460;
        }
        if ((n3 & 2) != 0) {
            n2 = 970;
        }
        return stackedBarMaker.head(n, n2);
    }

    private final String end() {
        return "</svg>";
    }

    private final String style(boolean darkMode) {
        String fill = "#000000";
        if (darkMode) {
            fill = "#ffffff";
        }
        return StringsKt.trimIndent((String)("\n    <style>\n        .label {font-size: 10px;font-family: \".AppleSystemUIFont\",\"Noto Sans\",sans-serif;font-weight: bold;fill: " + fill + "}\n        .desc { font-size: 12px; font-family: \".AppleSystemUIFont\",\"Noto Sans\",sans-serif; font-weight: bold; fill: " + fill + "}\n        .title { font-size: 18px; font-family: \".AppleSystemUIFont\",\"Noto Sans\",sans-serif; font-weight: normal; fill: " + fill + "}\n        .cool { fill: teal; stroke: teal; }\n        rect.outerbox { filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0.5)); }\n        rect.card { pointer-events: bounding-box; opacity: 1; }\n        rect.card:hover { opacity: 0.6; }\n    </style>\n        "));
    }

    private final String defs() {
        return "<defs>\n    <marker id=\"arrow\" markerWidth=\"10\" markerHeight=\"7\"\n            refX=\"0\" refY=\"3.5\" orient=\"auto\">\n        <polygon points=\"0 0, 10 3.5, 0 7\" fill=\"#00ee11\" opacity=\"0.1\"/>\n    </marker>\n    <marker id=\"arrowhead\" viewBox=\"0 -5 10 10\" refX=\"5\" refY=\"0\" markerWidth=\"4\" markerHeight=\"4\" orient=\"auto\">\n        <path class=\"cool\" d=\"M0,-5L10,0L0,5\"/>\n    </marker>\n</defs>";
    }

    private final String script() {
        return "<script>\n    var show = function(id) {\n        var elem = document.getElementById(id)\n        if(elem) {\n            elem.setAttribute(\"visibility\", \"visible\");\n        }\n    };\n    var hide = function (id) {\n        var elem = document.getElementById(id)\n        if(elem) {\n            elem.setAttribute(\"visibility\", \"hidden\");\n        }\n    };\n</script>";
    }

    public StackedBarMaker() {
        this(false, 1, null);
    }
}

