/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a \u0010\u0000\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\u0005\u001a\u0010\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020\u0005\u00a8\u0006\u000b"}, d2={"addLinebreaks", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "input", "", "maxLineLength", "", "escapeXml", "makeLines", "", "docops-button-render"})
public final class StringFunctionsKt {
    @NotNull
    public static final String escapeXml(@NotNull String $this$escapeXml) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeXml, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        int n = $this$escapeXml.length();
        for (int i = 0; i < n; ++i) {
            char element = $this$escapeXml.charAt(i);
            char c = element;
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c > '~') {
                sb.append("&#" + c + ';');
                continue;
            }
            sb.append(c);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final List<StringBuilder> addLinebreaks(@NotNull String input, int maxLineLength) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List list = new ArrayList();
        StringTokenizer tok = new StringTokenizer(input, " ");
        StringBuilder output = new StringBuilder(input.length());
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            if (lineLen + word.length() > maxLineLength) {
                list.add(output);
                output = new StringBuilder(input.length());
                lineLen = 0;
            }
            output.append(word + ' ');
            lineLen += word.length();
        }
        if (list.size() == 0 || lineLen > 0) {
            list.add(output);
        }
        return list;
    }

    @NotNull
    public static final List<String> makeLines(@NotNull String $this$makeLines) {
        Intrinsics.checkNotNullParameter((Object)$this$makeLines, (String)"<this>");
        String[] stringArray = new String[]{" "};
        return StringsKt.split$default((CharSequence)$this$makeLines, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }
}

