/*
 * Decompiled with CFR 0.152.
 */
package io.doov.assertions;

import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.Result;
import io.doov.core.dsl.meta.Metadata;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;

public class ResultAssert
extends AbstractAssert<ResultAssert, Result> {
    ResultAssert(Result actual, Class<?> selfType) {
        super((Object)actual, selfType);
    }

    public ResultAssert isTrue() {
        if (!((Result)this.actual).isTrue()) {
            this.failWithMessage("Expected result to be true (invalidated nodes: " + this.getInvalidatedMetadata() + ")", new Object[0]);
        }
        return this;
    }

    public ResultAssert isFalse() {
        if (!((Result)this.actual).isFalse()) {
            this.failWithMessage("Expected result to be false (invalidated nodes: " + this.getInvalidatedMetadata() + ")", new Object[0]);
        }
        return this;
    }

    public ResultAssert hasFailureCause(String message) {
        return this.hasFailureCause(message, Locale.getDefault());
    }

    public ResultAssert hasFailureCause(String message, Locale locale) {
        if (!((Result)this.actual).getFailureCause(locale).equals(message)) {
            this.failWithMessage("Expected result to have message '" + message + "' but was '" + ((Result)this.actual).getFailureCause() + "'", new Object[0]);
        }
        return this;
    }

    public ResultAssert hasNoFailureCause() {
        if (((Result)this.actual).getFailureCause() != null) {
            this.failWithMessage("Expected result to null message but was " + ((Result)this.actual).getFailureCause(), new Object[0]);
        }
        return this;
    }

    public ResultAssert isEvalFalse(Metadata metadata) {
        if (!((Result)this.actual).getContext().isEvalFalse(metadata)) {
            this.failWithMessage("Expected result to have invalidated nodes + " + metadata.readable() + " but was " + this.getInvalidatedMetadata(), new Object[0]);
        }
        return this;
    }

    public ResultAssert isEvalTrue(Metadata metadata) {
        if (!((Result)this.actual).getContext().isEvalTrue(metadata)) {
            this.failWithMessage("Expected result to have validated nodes + " + metadata.readable() + " but was " + this.getValidatedMetadata(), new Object[0]);
        }
        return this;
    }

    public ResultAssert hasNoInvalidatedMetadata() {
        if (!((Result)this.actual).getContext().getEvalFalse().isEmpty()) {
            this.failWithMessage("Expected result to have empty invalidated nodes but was " + this.getInvalidatedMetadata(), new Object[0]);
        }
        return this;
    }

    private List<String> getInvalidatedMetadata() {
        return ((Result)this.actual).getContext().getEvalFalse().stream().map(Readable::readable).collect(Collectors.toList());
    }

    private List<String> getValidatedMetadata() {
        return ((Result)this.actual).getContext().getEvalTrue().stream().map(Readable::readable).collect(Collectors.toList());
    }
}

