/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl.base;

import io.doov.core.FieldModel;
import io.doov.core.dsl.field.types.Function;
import io.doov.core.dsl.impl.DefaultFunction;
import io.doov.core.dsl.impl.LeafStepCondition;
import io.doov.core.dsl.impl.num.IntegerFunction;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.function.StringFunctionMetadata;
import io.doov.core.dsl.meta.predicate.PredicateMetadata;
import io.doov.core.dsl.meta.predicate.UnaryPredicateMetadata;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;

public class StringFunction
extends DefaultFunction<String, PredicateMetadata> {
    public StringFunction(PredicateMetadata metadata, BiFunction<FieldModel, Context, Optional<String>> value) {
        super(metadata, value);
    }

    public final StepCondition contains(String value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)StringFunctionMetadata.containsMetadata(this.metadata, value), this.getFunction(), value, String::contains);
    }

    public final StepCondition contains(StringFunction value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)StringFunctionMetadata.containsMetadata(this.metadata, value), this.getFunction(), value.getFunction(), String::contains);
    }

    public final StepCondition matches(String value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)StringFunctionMetadata.matchesMetadata(this.metadata, value), this.getFunction(), value, String::matches);
    }

    public final StepCondition startsWith(String value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)StringFunctionMetadata.startsWithMetadata(this.metadata, value), this.getFunction(), value, String::startsWith);
    }

    public final StepCondition endsWith(String value) {
        return LeafStepCondition.stepCondition((PredicateMetadata)StringFunctionMetadata.endsWithMetadata(this.metadata, value), this.getFunction(), value, String::endsWith);
    }

    public IntegerFunction length() {
        return new IntegerFunction((PredicateMetadata)UnaryPredicateMetadata.lengthIsMetadata(this.metadata), (model, context) -> this.value((FieldModel)model, (Context)context).map(String::length));
    }

    public IntegerFunction parseInt() {
        return new IntegerFunction((PredicateMetadata)this.metadata, (model, context) -> this.value((FieldModel)model, (Context)context).map(Integer::parseInt));
    }

    public StringFunction trim() {
        return new StringFunction(UnaryPredicateMetadata.trimMetadata(this.metadata), (model, context) -> this.value((FieldModel)model, (Context)context).map(String::trim));
    }

    public StringFunction replaceAll(String regex, String replacement) {
        return new StringFunction(StringFunctionMetadata.replaceAllMetadata(this.metadata, regex, replacement), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> s.replaceAll(regex, replacement)));
    }

    public StringFunction replaceAll(Function<String> regexFunction, Function<String> replacementFunction) {
        return new StringFunction(StringFunctionMetadata.replaceAllMetadata(this.metadata, regexFunction, replacementFunction), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> {
            Optional regex = regexFunction.value((FieldModel)model, (Context)context);
            Optional replacement = replacementFunction.value((FieldModel)model, (Context)context);
            if (regex.isPresent() && replacement.isPresent()) {
                return s.replaceAll((String)regex.get(), (String)replacement.get());
            }
            return s;
        }));
    }

    public StringFunction substring(int beginIndex, int endIndex) {
        return new StringFunction(StringFunctionMetadata.substringMetadata(this.metadata, beginIndex, endIndex), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> s.substring(beginIndex, endIndex)));
    }

    public StringFunction substring(Function<Integer> beginIndexFunction, Function<Integer> endIndexFunction) {
        return new StringFunction(StringFunctionMetadata.substringMetadata(this.metadata, beginIndexFunction, endIndexFunction), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> {
            Optional beginIndex = beginIndexFunction.value((FieldModel)model, (Context)context);
            Optional endIndex = endIndexFunction.value((FieldModel)model, (Context)context);
            if (beginIndex.isPresent() && endIndex.isPresent()) {
                return s.substring((Integer)beginIndex.get(), (Integer)endIndex.get());
            }
            return s;
        }));
    }

    public StringFunction upperCase(Locale locale) {
        return new StringFunction(StringFunctionMetadata.upperCaseMetadata(this.metadata, locale), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> s.toUpperCase(locale)));
    }

    public StringFunction lowerCase(Locale locale) {
        return new StringFunction(StringFunctionMetadata.lowerCaseMetadata(this.metadata, locale), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> s.toLowerCase(locale)));
    }

    public StringFunction concat(String other) {
        return new StringFunction(StringFunctionMetadata.concatMetadata(this.metadata, other), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> s.concat(other)));
    }

    public StringFunction concat(Function<String> otherStringFunction) {
        return new StringFunction(StringFunctionMetadata.concatMetadata(this.metadata, otherStringFunction), (model, context) -> this.value((FieldModel)model, (Context)context).map(s -> otherStringFunction.value((FieldModel)model, (Context)context).map(s::concat).orElse((String)s)));
    }
}

