/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.StaticMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class IterableMetadata<E, T extends Iterable<E>>
extends LeafMetadata<IterableMetadata<E, T>> {
    private final T value;
    private final List<StaticMetadata<E>> items;

    private IterableMetadata(MetadataType type, T value) {
        super(type);
        this.value = value;
        this.items = new ArrayList<StaticMetadata<E>>();
        value.forEach(e -> this.items.add(StaticMetadata.create(() -> e)));
    }

    public static <V, U extends Iterable<V>> IterableMetadata<V, U> create(Supplier<U> valueSupplier) {
        return (IterableMetadata)new IterableMetadata(MetadataType.MAPPING_LEAF_ITERABLE, (Iterable)valueSupplier.get()).valueSupplier(valueSupplier);
    }

    public T value() {
        return this.value;
    }

    public List<StaticMetadata<E>> items() {
        return this.items;
    }
}

