/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.FieldId;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.meta.ElementType;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataType;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import io.doov.core.dsl.meta.function.TemplateParamMetadata;
import io.doov.core.dsl.meta.predicate.FieldMetadata;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldCollector {
    public static List<FieldId> collect(Metadata metadata) {
        return AstVisitorUtils.collect(metadata, FieldCollector::fieldsOf).collect(Collectors.toList());
    }

    public static Stream<FieldId> fieldsOf(Metadata metadata) {
        if (metadata instanceof LeafMetadata) {
            return ((LeafMetadata)metadata).elements().stream().filter(e -> e.getType() == ElementType.FIELD).map(e -> {
                Metadata fieldMetadata = ((DslField)e.getReadable()).getMetadata();
                if (fieldMetadata.type() == MetadataType.TEMPLATE_PARAM) {
                    return FieldCollector.templateParam((TemplateParamMetadata)fieldMetadata);
                }
                return ((FieldMetadata)fieldMetadata).field().id();
            });
        }
        return Stream.empty();
    }

    private static FieldId templateParam(TemplateParamMetadata metadata) {
        if (metadata.getRight().type() == MetadataType.EMPTY) {
            return null;
        }
        return ((FieldMetadata)metadata.childAt(1)).field().id();
    }
}

