/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.runtime;

import io.doov.core.FieldId;
import io.doov.core.dsl.runtime.ListPathMethod;
import io.doov.core.dsl.runtime.PathMethod;
import io.doov.core.dsl.runtime.RuntimeField;
import io.doov.core.dsl.runtime.SimplePathMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class FieldChainBuilder<B, T, R> {
    private final Class<B> rootType;
    private final List<PathMethod<Object, Object>> chain;
    private final FieldId id;
    private String readable;
    private FieldId[] siblings;
    private boolean isTransient;

    private FieldChainBuilder(Class<B> rootType, List<PathMethod<Object, Object>> chain, FieldId id, String readable, FieldId[] siblings, boolean isTransient) {
        this.rootType = rootType;
        this.chain = chain;
        this.id = id;
        this.readable = readable;
        this.siblings = siblings == null ? new FieldId[]{} : siblings;
        this.isTransient = isTransient;
    }

    public static <T> Class<T> generify(Class<?> cls) {
        return cls;
    }

    public static <B> FieldChainBuilder<B, B, B> from(Class<B> root, FieldId id) {
        return new FieldChainBuilder(root, new ArrayList<PathMethod<Object, Object>>(), id, null, null, false);
    }

    public FieldChainBuilder<B, T, R> readable(String readable) {
        this.readable = readable;
        return this;
    }

    public FieldChainBuilder<B, T, R> siblings(FieldId ... siblings) {
        this.siblings = siblings;
        return this;
    }

    public FieldChainBuilder<B, T, R> _transient(boolean isTransient) {
        this.isTransient = isTransient;
        return this;
    }

    public <O> FieldChainBuilder<B, R, O> get(Function<R, O> readMethod, BiConsumer<R, O> writeMethod, Supplier<O> supplier) {
        SimplePathMethod<R, O> method = new SimplePathMethod<R, O>(supplier, readMethod, writeMethod);
        this.chain.add(method);
        return new FieldChainBuilder<B, T, R>(this.rootType, this.chain, this.id, this.readable, this.siblings, this.isTransient);
    }

    public <O> FieldChainBuilder<B, R, O> list(Function<R, List<O>> readMethod, BiConsumer<R, List<O>> writeMethod, Supplier<O> supplier) {
        ListPathMethod<R, O> method = new ListPathMethod<R, O>(supplier, readMethod, writeMethod, this.id.position());
        this.chain.add(method);
        return new FieldChainBuilder<B, T, R>(this.rootType, this.chain, this.id, this.readable, this.siblings, this.isTransient);
    }

    public <O> FieldChainBuilder<B, R, O> list(Function<R, List<O>> readMethod, BiConsumer<R, List<O>> writeMethod, Supplier<O> supplier, int positionInList) {
        ListPathMethod<R, O> method = new ListPathMethod<R, O>(supplier, readMethod, writeMethod, positionInList);
        this.chain.add(method);
        return new FieldChainBuilder<B, T, R>(this.rootType, this.chain, this.id, this.readable, this.siblings, this.isTransient);
    }

    public <O> RuntimeField<B, O> field(Function<R, O> readMethod, BiConsumer<R, O> writeMethod, Class<O> type, Class<?> ... genericTypes) {
        SimplePathMethod<O, O> method;
        SimplePathMethod<O, O> m = method = new SimplePathMethod<O, O>(null, readMethod, writeMethod);
        return new RuntimeField(this.chain, m, this.id, this.readable, this.siblings, type, genericTypes, this.isTransient);
    }

    public <O> RuntimeField<B, O> fieldInList(Function<R, List<O>> readMethod, BiConsumer<R, List<O>> writeMethod, Class<O> type, Class<?> ... genericTypes) {
        ListPathMethod<O, O> method;
        ListPathMethod<O, O> m = method = new ListPathMethod<O, O>(null, readMethod, writeMethod, this.id.position());
        return new RuntimeField(this.chain, m, this.id, this.readable, this.siblings, type, genericTypes, this.isTransient);
    }
}

