/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.runtime;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.FieldModel;
import io.doov.core.dsl.field.types.BooleanFieldInfo;
import io.doov.core.dsl.field.types.CharacterFieldInfo;
import io.doov.core.dsl.field.types.DoubleFieldInfo;
import io.doov.core.dsl.field.types.EnumFieldInfo;
import io.doov.core.dsl.field.types.FloatFieldInfo;
import io.doov.core.dsl.field.types.IntegerFieldInfo;
import io.doov.core.dsl.field.types.IterableFieldInfo;
import io.doov.core.dsl.field.types.LocalDateFieldInfo;
import io.doov.core.dsl.field.types.LocalDateTimeFieldInfo;
import io.doov.core.dsl.field.types.LocalTimeFieldInfo;
import io.doov.core.dsl.field.types.LongFieldInfo;
import io.doov.core.dsl.field.types.StringFieldInfo;
import io.doov.core.dsl.runtime.FieldChainBuilder;
import io.doov.core.dsl.runtime.RuntimeField;
import io.doov.core.serial.TypeAdapterRegistry;
import io.doov.core.serial.TypeAdapters;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Stream;

public final class GenericModel
implements FieldModel {
    private final List<RuntimeField<GenericModel, Object>> fields = new ArrayList<RuntimeField<GenericModel, Object>>();
    private final Map<FieldId, Object> valueMap = new HashMap<FieldId, Object>();
    private final TypeAdapterRegistry adapterRegistry;

    public GenericModel() {
        this(TypeAdapters.INSTANCE);
    }

    public GenericModel(TypeAdapterRegistry adapterRegistry) {
        this.adapterRegistry = adapterRegistry;
    }

    @Override
    public <T> T get(FieldId id) {
        return (T)this.valueMap.get(id);
    }

    @Override
    public <T> void set(FieldId id, T value) {
        this.valueMap.put(id, value);
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> stream() {
        return this.valueMap.entrySet().stream();
    }

    @Override
    public Iterator<Map.Entry<FieldId, Object>> iterator() {
        return this.valueMap.entrySet().iterator();
    }

    @Override
    public Spliterator<Map.Entry<FieldId, Object>> spliterator() {
        return this.valueMap.entrySet().spliterator();
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> parallelStream() {
        return this.valueMap.entrySet().parallelStream();
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return new ArrayList<FieldInfo>(this.fields);
    }

    @Override
    public TypeAdapterRegistry getTypeAdapterRegistry() {
        return this.adapterRegistry;
    }

    private <T> RuntimeField<GenericModel, T> runtimeField(T value, String fieldName, Class<?> ... genericTypes) {
        FieldId fieldId = () -> fieldName;
        this.set(fieldId, value);
        return FieldChainBuilder.from(GenericModel.class, fieldId).readable(fieldName).field(o -> o.get(fieldId), (o, v) -> o.set(fieldId, v), value == null ? Void.TYPE : value.getClass(), genericTypes).register(this.fields);
    }

    public BooleanFieldInfo booleanField(boolean value, String fieldName) {
        return new BooleanFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public CharacterFieldInfo charField(char value, String fieldName) {
        return new CharacterFieldInfo(this.runtimeField(Character.valueOf(value), fieldName, new Class[0]));
    }

    public DoubleFieldInfo doubleField(double value, String fieldName) {
        return new DoubleFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public <E extends Enum<E>> EnumFieldInfo<E> enumField(E value, String fieldName) {
        return new EnumFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public FloatFieldInfo floatField(float value, String fieldName) {
        return new FloatFieldInfo(this.runtimeField(Float.valueOf(value), fieldName, new Class[0]));
    }

    public IntegerFieldInfo intField(int value, String fieldName) {
        return new IntegerFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public LocalDateFieldInfo localDateField(LocalDate value, String fieldName) {
        return new LocalDateFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public LocalDateTimeFieldInfo localDateTimeField(LocalDateTime value, String fieldName) {
        return new LocalDateTimeFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public LocalTimeFieldInfo localTimeField(LocalTime value, String fieldName) {
        return new LocalTimeFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public LongFieldInfo longField(long value, String fieldName) {
        return new LongFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public StringFieldInfo stringField(String value, String fieldName) {
        return new StringFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }

    public <T, C extends Iterable<T>> IterableFieldInfo<T, C> iterableField(C value, String fieldName) {
        return new IterableFieldInfo(this.runtimeField(value, fieldName, new Class[0]));
    }
}

