/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.runtime;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.FieldModel;
import io.doov.core.dsl.runtime.RuntimeField;
import io.doov.core.dsl.runtime.RuntimeFieldRegistry;
import io.doov.core.serial.TypeAdapterRegistry;
import io.doov.core.serial.TypeAdapters;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Stream;

public class RuntimeModel<M>
implements FieldModel {
    private RuntimeFieldRegistry<M> fieldRegistry;
    private M model;

    public RuntimeModel(RuntimeFieldRegistry<M> fieldRegistry, M model) {
        this.fieldRegistry = fieldRegistry;
        this.model = model;
    }

    @Override
    public <T> T get(FieldId id) {
        RuntimeField<M, Object> runtimeField = this.fieldRegistry.get(id);
        if (runtimeField == null) {
            return null;
        }
        return (T)runtimeField.get(this.model);
    }

    @Override
    public <T> void set(FieldId fieldId, T value) {
        RuntimeField<M, Object> runtimeField = this.fieldRegistry.get(fieldId);
        if (runtimeField != null) {
            runtimeField.set(this.model, value);
        }
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> stream() {
        return this.fieldRegistry.stream().map(e -> new SupplierEntry<M>(e, this.model));
    }

    @Override
    public Iterator<Map.Entry<FieldId, Object>> iterator() {
        return new Iterator<Map.Entry<FieldId, Object>>(){
            int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < RuntimeModel.this.fieldRegistry.runtimeFields().size();
            }

            @Override
            public Map.Entry<FieldId, Object> next() {
                try {
                    RuntimeField mObjectRuntimeField = RuntimeModel.this.fieldRegistry.runtimeFields().get(this.position);
                    SupplierEntry<Object> supplierEntry = new SupplierEntry<Object>(mObjectRuntimeField, RuntimeModel.this.model);
                    return supplierEntry;
                }
                finally {
                    ++this.position;
                }
            }
        };
    }

    @Override
    public Spliterator<Map.Entry<FieldId, Object>> spliterator() {
        Map.Entry[] entries = new Map.Entry[this.fieldRegistry.runtimeFields().size()];
        for (int i = 0; i < this.fieldRegistry.runtimeFields().size(); ++i) {
            RuntimeField<M, Object> runtimeField = this.fieldRegistry.runtimeFields().get(i);
            entries[i] = new SupplierEntry<M>(runtimeField, this.model);
        }
        return Arrays.spliterator(entries, 0, entries.length);
    }

    @Override
    public Stream<Map.Entry<FieldId, Object>> parallelStream() {
        return ((Stream)this.fieldRegistry.stream().parallel()).map(e -> new SupplierEntry<M>(e, this.model));
    }

    @Override
    public List<FieldInfo> getFieldInfos() {
        return this.fieldRegistry.fieldInfos();
    }

    @Override
    public TypeAdapterRegistry getTypeAdapterRegistry() {
        return TypeAdapters.INSTANCE;
    }

    private static class SupplierEntry<M>
    implements Map.Entry<FieldId, Object> {
        final RuntimeField<M, Object> runtimeField;
        final M model;

        SupplierEntry(RuntimeField<M, Object> runtimeField, M model) {
            this.runtimeField = runtimeField;
            this.model = model;
        }

        @Override
        public FieldId getKey() {
            return this.runtimeField.id();
        }

        @Override
        public Object getValue() {
            return this.runtimeField.apply(this.model);
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.runtimeField.id() + ", " + String.valueOf(this.getValue());
        }
    }
}

