/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import io.doov.core.FieldId;
import io.doov.gen.GeneratorFieldInfo;
import io.doov.gen.VisitorPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class FieldInfoGen {
    FieldInfoGen() {
    }

    static Map<FieldId, GeneratorFieldInfo> createFieldInfos(Map<FieldId, VisitorPath> fieldPathMap) {
        return fieldPathMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, f -> GeneratorFieldInfo.fromVisitorPath((VisitorPath)f.getValue(), fieldPathMap.values())));
    }

    static String imports(Map<FieldId, GeneratorFieldInfo> fieldPaths) {
        return fieldPaths.entrySet().stream().flatMap(FieldInfoGen::toImports).filter(clazz -> clazz.contains(".")).filter(clazz -> !clazz.contains("java.lang.")).distinct().sorted().map(clazz -> "import " + clazz + ";").collect(Collectors.joining("\n"));
    }

    private static Stream<? extends String> toImports(Map.Entry<FieldId, GeneratorFieldInfo> e) {
        ArrayList<String> imports = new ArrayList<String>();
        FieldId fieldId = e.getKey();
        imports.add(fieldId.getClass().getName());
        GeneratorFieldInfo fieldInfo = e.getValue();
        imports.add(fieldInfo.type().getName());
        imports.addAll(Arrays.stream(fieldInfo.genericTypes()).map(Class::getName).collect(Collectors.toSet()));
        return imports.stream();
    }

    static String constants(Map<FieldId, GeneratorFieldInfo> fieldInfos, boolean enumFieldInfo) {
        return fieldInfos.entrySet().stream().sorted(Comparator.comparing(e -> ((FieldId)e.getKey()).code())).map(e -> enumFieldInfo ? FieldInfoGen.writeFieldInfoEnum((GeneratorFieldInfo)((Object)((Object)e.getValue()))) : FieldInfoGen.writeFieldInfo((GeneratorFieldInfo)((Object)((Object)e.getValue())))).collect(Collectors.joining("\n\n"));
    }

    private static String writeFieldInfo(GeneratorFieldInfo fieldInfo) {
        return "    public static final FieldInfo " + fieldInfo.id().toString() + " = " + fieldInfo.writeBuilder() + "\n                    .build(ALL);";
    }

    private static String writeFieldInfoEnum(GeneratorFieldInfo fieldInfo) {
        return "    " + fieldInfo.id().toString() + "(" + fieldInfo.writeBuilder() + "\n                    .build()),";
    }
}

