/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import com.google.common.base.Strings;
import io.doov.core.CodeLookup;
import io.doov.core.CodeValuable;
import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.dsl.field.DelegatingFieldInfoImpl;
import io.doov.core.dsl.field.FieldInfoBuilder;
import io.doov.gen.ModelWrapperGen;
import io.doov.gen.VisitorPath;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GeneratorFieldInfo
extends DelegatingFieldInfoImpl {
    private static final Pattern UNDER = Pattern.compile("_");
    private final VisitorPath path;

    public GeneratorFieldInfo(FieldInfo fieldInfo, VisitorPath path) {
        super(fieldInfo);
        this.path = path;
    }

    public VisitorPath getPath() {
        return this.path;
    }

    static GeneratorFieldInfo fromVisitorPath(VisitorPath path, Collection<VisitorPath> allPaths) {
        return new GeneratorFieldInfo((FieldInfo)FieldInfoBuilder.fieldInfo().fieldId(path.getFieldId()).type(ModelWrapperGen.getterType(path)).readable(GeneratorFieldInfo.formatReadable(path))._transient(path.isTransient()).codeValuable(GeneratorFieldInfo.isAssignable(path, CodeValuable.class)).codeLookup(GeneratorFieldInfo.isAssignable(path, CodeLookup.class)).genericTypes(GeneratorFieldInfo.genericClasses(path)).siblings((FieldId[])GeneratorFieldInfo.siblings(path, allPaths).stream().sorted(Comparator.comparing(FieldId::code)).toArray(FieldId[]::new)).build(), path);
    }

    private static boolean isAssignable(VisitorPath path, Class<?> clazz) {
        Method lastMethod = path.getPath().get(path.getPath().size() - 1);
        return clazz.isAssignableFrom(lastMethod.getReturnType());
    }

    private static Set<FieldId> siblings(VisitorPath currentPath, Collection<VisitorPath> collected) {
        String currentCanonicalPath = currentPath.canonicalPath();
        return collected.stream().filter(p -> p.getFieldId() != currentPath.getFieldId()).filter(p -> p.canonicalPath().equals(currentCanonicalPath)).map(VisitorPath::getFieldId).collect(Collectors.toSet());
    }

    private static String formatReadable(VisitorPath currentPath) {
        return Strings.isNullOrEmpty((String)currentPath.getReadable()) ? Arrays.stream(UNDER.split(currentPath.getFieldId().code())).map(String::toLowerCase).collect(Collectors.joining(" ")) : currentPath.getReadable();
    }

    private static Class[] genericClasses(VisitorPath path) {
        Type returnType = path.getPath().get(path.getPath().size() - 1).getGenericReturnType();
        Class[] genericClasses = new Class[]{};
        if (returnType instanceof ParameterizedType) {
            ParameterizedType genericReturnType = (ParameterizedType)returnType;
            genericClasses = (Class[])Arrays.stream(genericReturnType.getActualTypeArguments()).map(t -> (Class)t).toArray(Class[]::new);
        }
        return genericClasses;
    }

    String writeBuilder() {
        StringBuilder constant = new StringBuilder();
        constant.append("fieldInfo()");
        constant.append("\n                    ");
        constant.append(".fieldId(");
        constant.append(this.id().getClass().getSimpleName());
        constant.append(".");
        constant.append(this.id().toString());
        constant.append(")");
        constant.append("\n                    ");
        constant.append(".readable(\"");
        constant.append(this.readable());
        constant.append("\")");
        constant.append("\n                    ");
        constant.append(".type(");
        if (this.type().isPrimitive()) {
            constant.append(ModelWrapperGen.primitiveBoxingType(this.type()));
            constant.append(".TYPE");
        } else {
            constant.append(this.type().getSimpleName());
            constant.append(".class");
        }
        constant.append(")");
        if (this.isTransient()) {
            constant.append("\n                    ");
            constant.append("._transient(");
            constant.append(Boolean.toString(true));
            constant.append(")");
        }
        if (this.isCodeValuable()) {
            constant.append("\n                    ");
            constant.append(".codeValuable(");
            constant.append(Boolean.toString(true));
            constant.append(")");
        }
        if (this.isCodeLookup()) {
            constant.append("\n                    ");
            constant.append(".codeLookup(");
            constant.append(Boolean.toString(true));
            constant.append(")");
        }
        if (this.genericTypes().length != 0) {
            constant.append("\n                    ");
            constant.append(".genericTypes(");
            constant.append(GeneratorFieldInfo.formatGenericTypesClass(this.genericTypes()));
            constant.append(")");
        }
        if (this.siblings().length != 0) {
            constant.append("\n                    ");
            constant.append(".siblings(");
            constant.append(GeneratorFieldInfo.formatSiblings(Arrays.stream(this.siblings()).collect(Collectors.toSet())));
            constant.append(")");
        }
        return constant.toString();
    }

    private static String formatSiblings(Set<FieldId> siblings) {
        if (siblings.isEmpty()) {
            return "";
        }
        return siblings.stream().sorted(Comparator.comparing(FieldId::code)).map(f -> f.getClass().getSimpleName() + "." + f.toString()).collect(Collectors.joining(", "));
    }

    private static String formatGenericTypesClass(Class<?>[] genericTypes) {
        return Arrays.stream(genericTypes).map(c -> c.getSimpleName() + ".class").collect(Collectors.joining(", "));
    }
}

