/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import io.doov.core.FieldId;
import io.doov.core.FieldTransient;
import io.doov.core.Path;
import io.doov.core.PathConstraint;
import io.doov.gen.Visitor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

final class ModelVisitor {
    private final Logger log;

    public ModelVisitor(Logger log) {
        this.log = log;
    }

    public void visitModel(Class<?> clazz, Class<? extends FieldId> fieldClass, Visitor visitor, String packageFilter) throws IntrospectionException, IllegalArgumentException {
        this.log.debug("starting visiting class " + clazz.getName());
        this.visitModel(clazz, fieldClass, visitor, new LinkedList<Method>(), packageFilter, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitModel(Class<?> clazz, Class<? extends FieldId> fieldClass, Visitor visitor, LinkedList<Method> path, String packageFilter, int deep) throws IntrospectionException, IllegalArgumentException {
        PropertyDescriptor[] propertyDescriptors;
        if (clazz == null) {
            return;
        }
        if (clazz.getPackage() == null) {
            return;
        }
        if (!clazz.getPackage().getName().startsWith(packageFilter)) {
            return;
        }
        if (clazz.isEnum()) {
            return;
        }
        if (deep > 8) {
            return;
        }
        this.log.debug("class " + clazz.getName());
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor desc : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            this.log.debug("property " + desc.getName() + " : " + (desc.getPropertyType() != null ? desc.getPropertyType().getSimpleName() : null) + " from " + clazz.getName());
            path.addLast(desc.getReadMethod());
            try {
                List<PathAnnotation> fieldTarget = this.getFieldTarget(clazz, desc, fieldClass);
                if (fieldTarget.isEmpty()) continue;
                this.log.debug(fieldTarget.size() + " path(s) found from  " + desc);
                boolean _transient = this.isTransient(clazz, desc);
                visitor.visit(fieldTarget, desc.getReadMethod(), desc.getWriteMethod(), path, _transient);
            }
            finally {
                path.removeLast();
            }
        }
        Collection<Method> otherMethods = this.methods(clazz, packageFilter);
        for (Method method : otherMethods) {
            path.addLast(method);
            try {
                this.visitModel(this.returnType(method, packageFilter), fieldClass, visitor, path, packageFilter, deep + 1);
            }
            finally {
                path.removeLast();
            }
        }
        this.visitModel(clazz.getSuperclass(), fieldClass, visitor, path, packageFilter, deep + 1);
    }

    private boolean isTransient(Class<?> clazz, PropertyDescriptor desc) {
        boolean declaredFieldTransient = false;
        try {
            Field field = clazz.getDeclaredField(desc.getName());
            declaredFieldTransient = field.getAnnotation(FieldTransient.class) != null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return declaredFieldTransient || desc.getReadMethod().getAnnotation(FieldTransient.class) != null || desc.getWriteMethod().getAnnotation(FieldTransient.class) != null;
    }

    private List<PathAnnotation> getFieldTarget(Class<?> clazz, PropertyDescriptor desc, Class<? extends FieldId> fieldClass) {
        if (desc.getReadMethod() == null || desc.getWriteMethod() == null) {
            return Collections.emptyList();
        }
        List<PathAnnotation> fieldTarget = Collections.emptyList();
        try {
            Field field = clazz.getDeclaredField(desc.getName());
            fieldTarget = this.getFieldTarget(field, fieldClass);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (fieldTarget.isEmpty()) {
            fieldTarget = this.getFieldTarget(desc.getReadMethod(), fieldClass);
        }
        if (fieldTarget.isEmpty()) {
            fieldTarget = this.getFieldTarget(desc.getWriteMethod(), fieldClass);
        }
        return fieldTarget;
    }

    private List<PathAnnotation> getFieldTarget(AccessibleObject executable, Class<? extends FieldId> fieldClass) {
        Annotation[] annotations = executable.getAnnotations();
        this.log.debug(annotations.length + " annotations to process from " + executable.toString());
        Set pathAnnotations = Arrays.stream(annotations).filter(a -> a.annotationType().getAnnotation(Path.class) != null).map(Annotation::annotationType).collect(Collectors.toSet());
        Arrays.stream(annotations).forEach(a -> {
            try {
                Method value = a.annotationType().getMethod("value", new Class[0]);
                Class<?> returnType = value.getReturnType();
                if (returnType.isArray() && returnType.getComponentType().isAnnotation()) {
                    Class<?> type = returnType.getComponentType();
                    pathAnnotations.add(type);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        });
        this.log.debug(pathAnnotations.size() + " paths annotations to process from " + executable.toString());
        try {
            return pathAnnotations.stream().flatMap(a -> Arrays.stream(executable.getAnnotationsByType((Class)a))).map(this::asPathAnnotation).filter(Objects::nonNull).filter(p -> fieldClass.isAssignableFrom(p.fieldId.getClass())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(executable.toString(), e);
        }
    }

    private PathAnnotation asPathAnnotation(Annotation annotation) {
        try {
            this.log.debug("process annotation " + annotation.toString());
            Method fieldIdGetter = this.getMethodByClass(annotation.annotationType(), FieldId.class);
            Method constraintGetter = this.getMethodByClass(annotation.annotationType(), PathConstraint.class);
            Method readableGetter = this.getMethodByName(annotation.annotationType(), "readable");
            return new PathAnnotation((FieldId)fieldIdGetter.invoke((Object)annotation, new Object[0]), (PathConstraint)constraintGetter.invoke((Object)annotation, new Object[0]), readableGetter == null ? null : (String)readableGetter.invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private Method getMethodByClass(Class<?> clazz, Class<?> interfaceType) {
        this.log.debug("process annotation type " + clazz.getName());
        return Arrays.stream(clazz.getMethods()).filter(f -> {
            this.log.debug("process annotation field " + f.toString());
            return interfaceType.isAssignableFrom(f.getReturnType());
        }).findFirst().orElseThrow(() -> new IllegalArgumentException(clazz + " needs method with " + interfaceType));
    }

    private Method getMethodByName(Class<?> clazz, String name) {
        this.log.debug("process annotation type " + clazz.getName());
        return Arrays.stream(clazz.getMethods()).filter(f -> {
            this.log.debug("process annotation field " + f.toString());
            return f.getName().equals(name);
        }).findFirst().orElse(null);
    }

    private Collection<Method> methods(Class<?> clazz, String packageFilter) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        if (clazz.getPackage() == null) {
            return Collections.emptySet();
        }
        if (!clazz.getPackage().getName().startsWith(packageFilter)) {
            return Collections.emptySet();
        }
        return this.filter(clazz.getMethods(), packageFilter);
    }

    private Collection<Method> filter(Method[] methods, String packageFilter) {
        List<Method> filtered = Arrays.stream(methods).filter(m -> !Modifier.isStatic(m.getModifiers())).filter(m -> !Modifier.isNative(m.getModifiers())).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> m.getReturnType() != null).filter(m -> !m.getReturnType().equals(Void.TYPE)).filter(m -> m.getParameterTypes().length == 0).filter(m -> m.getDeclaringClass().getPackage().getName().startsWith(packageFilter)).filter(m -> !m.getName().toLowerCase().contains("clone")).collect(Collectors.toList());
        ArrayList<Method> overrided = new ArrayList<Method>();
        for (Method method : filtered) {
            for (Method method2 : filtered) {
                if (method == method2 || !method.getName().equals(method2.getName()) || !method.getReturnType().isAssignableFrom(method2.getReturnType())) continue;
                overrided.add(method);
            }
        }
        filtered.removeAll(overrided);
        return filtered;
    }

    private Class<?> returnType(Method method, String packageFilter) {
        if (method.getGenericReturnType() == null) {
            return method.getReturnType();
        }
        if (method.getGenericReturnType().getTypeName().equals(method.getReturnType().getTypeName())) {
            return method.getReturnType();
        }
        if (method.getGenericReturnType() instanceof Class) {
            return (Class)method.getGenericReturnType();
        }
        if (List.class.isAssignableFrom(method.getReturnType()) && method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
            if (returnType == null) {
                return null;
            }
            if (returnType.getActualTypeArguments() == null) {
                return null;
            }
            if (returnType.getActualTypeArguments().length != 1) {
                return null;
            }
            if (returnType.getActualTypeArguments()[0].toString().startsWith(packageFilter)) {
                return null;
            }
            return (Class)returnType.getActualTypeArguments()[0];
        }
        return method.getReturnType();
    }

    static class PathAnnotation {
        final FieldId fieldId;
        final PathConstraint constraint;
        final String readable;

        private PathAnnotation(FieldId fieldId, PathConstraint constraint, String readable) {
            this.fieldId = fieldId;
            this.constraint = constraint;
            this.readable = readable;
        }
    }
}

