/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.doov.core.AbstractWrapper;
import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.FieldModel;
import io.doov.gen.VisitorPath;
import io.doov.gen.processor.MacroProcessor;
import io.doov.gen.processor.Templates;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;

final class ModelWrapperGen {
    ModelWrapperGen() {
    }

    static String mapFieldTypeIfStatement(String template, Map<FieldId, VisitorPath> collected) {
        StringBuilder buffer = new StringBuilder();
        collected.keySet().stream().map(Object::getClass).distinct().sorted(Comparator.comparing(Class::getName)).forEach(fieldType -> {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("field.id.type", fieldType.getName());
            buffer.append(MacroProcessor.replaceProperties(template, conf));
        });
        return buffer.toString();
    }

    static Map<FieldId, VisitorPath> validatePath(List<VisitorPath> collected, Logger log) {
        Map<FieldId, List<VisitorPath>> pathByFieldId = VisitorPath.pathByFieldId(collected);
        List<FieldId> invalidFieldId = pathByFieldId.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!invalidFieldId.isEmpty()) {
            invalidFieldId.forEach(f -> log.debug(f.code() + " - " + pathByFieldId.get(f)));
            throw new IllegalStateException("some field ids have more than one path : " + invalidFieldId.toString());
        }
        TreeMap<FieldId, VisitorPath> paths = new TreeMap<FieldId, VisitorPath>(Comparator.comparing(FieldId::code));
        pathByFieldId.forEach((fieldId, fieldPaths) -> {
            VisitorPath cfr_ignored_0 = (VisitorPath)paths.put((FieldId)fieldId, (VisitorPath)fieldPaths.iterator().next());
        });
        return paths;
    }

    static String mapFieldProperties(Map<FieldId, VisitorPath> collected, Class<?> modelClass) {
        StringBuilder buffer = new StringBuilder();
        collected.forEach((fieldId, visitorPath) -> {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("field.id.name", fieldId.toString());
            conf.put("field.id.type", fieldId.getClass().getName());
            conf.put("supplier.method", ModelWrapperGen.supplierMethod(fieldId, visitorPath, modelClass));
            conf.put("consumer.method", ModelWrapperGen.consumerMethod(fieldId, visitorPath, modelClass));
            buffer.append(MacroProcessor.replaceProperties(Templates.propertyIdEnum, conf));
        });
        return buffer.toString();
    }

    private static String supplierMethod(FieldId fieldId, VisitorPath path, Class<?> modelClass) {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("field.class.name", fieldId.getClass().getName());
        conf.put("field.id.name", fieldId.toString());
        conf.put("field.type", ModelWrapperGen.getterBoxingType(path, fieldId.position()));
        conf.put("target.model.class.name", modelClass.getSimpleName());
        conf.put("null.check", ModelWrapperGen.nullCheck(path));
        conf.put("getter.path", ModelWrapperGen.getterPath(path));
        return MacroProcessor.replaceProperties(Templates.propertyLiteralSupplier, conf);
    }

    private static String consumerMethod(FieldId fieldId, VisitorPath path, Class<?> modelClass) {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("field.class.name", fieldId.getClass().getName());
        conf.put("field.id.name", fieldId.toString());
        conf.put("field.type", ModelWrapperGen.getterBoxingType(path, fieldId.position()));
        conf.put("target.model.class.name", modelClass.getSimpleName());
        conf.put("lazy.init", ModelWrapperGen.lazyInit(path));
        conf.put("setter.path", ModelWrapperGen.setterPath(path));
        conf.put("param", ModelWrapperGen.setterBoxingChecker(path));
        return MacroProcessor.replaceProperties(Templates.propertyLiteralConsumer, conf);
    }

    static String mapGetter(Map<FieldId, VisitorPath> collected) {
        return ModelWrapperGen.fieldTypes(collected).stream().map(fieldType -> {
            Map<FieldId, VisitorPath> paths = ModelWrapperGen.filterByFieldType(collected, fieldType);
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("field.id.type", fieldType.getName());
            conf.put("switch.content", ModelWrapperGen.getterSwitchContent(paths));
            return MacroProcessor.replaceProperties(Templates.mapGetMethod, conf);
        }).collect(Collectors.joining("\n\n"));
    }

    static String mapSetter(Map<FieldId, VisitorPath> collected) {
        return ModelWrapperGen.fieldTypes(collected).stream().map(fieldType -> {
            Map<FieldId, VisitorPath> paths = ModelWrapperGen.filterByFieldType(collected, fieldType);
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("field.id.type", fieldType.getName());
            conf.put("switch.content", ModelWrapperGen.setterSwitchContent(paths));
            return MacroProcessor.replaceProperties(Templates.mapSetMethod, conf);
        }).collect(Collectors.joining("\n\n"));
    }

    private static List<Class<?>> fieldTypes(Map<FieldId, VisitorPath> collected) {
        return collected.keySet().stream().map(Object::getClass).distinct().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
    }

    private static String nullCheck(VisitorPath path) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i < path.getPath().size(); ++i) {
            Method lastGetMethod = path.getPath().get(i - 1);
            List<Method> subPaths = path.getPath().subList(0, i);
            buffer.append(ModelWrapperGen.nullCheck(subPaths));
            if (!List.class.isAssignableFrom(lastGetMethod.getReturnType())) continue;
            buffer.append(ModelWrapperGen.sizeCheck(subPaths, path.getFieldId()));
        }
        return buffer.toString();
    }

    private static String nullCheck(List<Method> paths) {
        StringBuilder buffer = new StringBuilder();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("partial.path", VisitorPath.getterPath(paths));
        buffer.append(MacroProcessor.replaceProperties(Templates.nullCheckBlock, conf));
        return buffer.toString();
    }

    private static String sizeCheck(List<Method> paths, FieldId fieldId) {
        StringBuilder buffer = new StringBuilder();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("partial.path", VisitorPath.getterPath(paths));
        conf.put("size", String.valueOf(fieldId.position()));
        conf.put("index", String.valueOf(fieldId.position() - 1));
        buffer.append(MacroProcessor.replaceProperties(Templates.sizeCheckBlock, conf));
        return buffer.toString();
    }

    private static String lazyInit(VisitorPath path) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i < path.getPath().size(); ++i) {
            Method lastGetMethod = path.getPath().get(i - 1);
            List<Method> pathSubList = path.getPath().subList(0, i);
            if (List.class.isAssignableFrom(lastGetMethod.getReturnType())) {
                buffer.append(ModelWrapperGen.lazyInitList(pathSubList, path.getFieldId(), lastGetMethod));
                continue;
            }
            buffer.append(ModelWrapperGen.lazyInit(pathSubList, path.getFieldId(), lastGetMethod));
        }
        return buffer.toString();
    }

    private static String lazyInit(List<Method> paths, FieldId field, Method lastGetMethod) {
        Class<?> returnType = lastGetMethod.getReturnType();
        StringBuilder buffer = new StringBuilder();
        HashMap<String, String> conf = new HashMap<String, String>();
        String setterName = ModelWrapperGen.setterName(lastGetMethod);
        conf.put("partial.path", VisitorPath.getterPath(paths));
        conf.put("partial.path.init", ModelWrapperGen.setterPath(paths, setterName, field.position(), false));
        conf.put("param", "new " + returnType.getName() + ModelWrapperGen.diamond(returnType) + "()");
        buffer.append(MacroProcessor.replaceProperties(Templates.lazyInitBlock, conf));
        return buffer.toString();
    }

    private static String diamond(Class<?> returnType) {
        if (returnType.getTypeParameters().length > 0) {
            return "<>";
        }
        return "";
    }

    private static String lazyInitList(List<Method> paths, FieldId field, Method lastGetMethod) {
        StringBuilder buffer = new StringBuilder();
        HashMap<String, String> conf = new HashMap<String, String>();
        String setterName = ModelWrapperGen.setterName(lastGetMethod);
        conf.put("list.content.as.null", ModelWrapperGen.listContentAsNull(paths, field));
        conf.put("partial.path", VisitorPath.getterPath(paths));
        conf.put("partial.path.init", ModelWrapperGen.setterPath(paths, setterName, field.position(), false));
        conf.put("param", "new " + ArrayList.class.getName() + "<>()");
        conf.put("index", Integer.toString(field.position() - 1));
        conf.put("position", Integer.toString(field.position()));
        ParameterizedType paramType = (ParameterizedType)lastGetMethod.getGenericReturnType();
        Class paramType0 = (Class)paramType.getActualTypeArguments()[0];
        conf.put("target.type", paramType0.getName());
        buffer.append(MacroProcessor.replaceProperties(Templates.lazyInitListBlock, conf));
        return buffer.toString();
    }

    private static String listContentAsNull(List<Method> paths, FieldId field) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < field.position() - 1; ++i) {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("partial.path", VisitorPath.getterPath(paths));
            conf.put("index", Integer.toString(i));
            conf.put("position", Integer.toString(i + 1));
            buffer.append(MacroProcessor.replaceProperties(Templates.lazyInitListBlockNull, conf));
        }
        return buffer.toString();
    }

    private static List<FieldId> sortFields(Set<FieldId> FieldIds) {
        ArrayList<FieldId> sortedList = new ArrayList<FieldId>(FieldIds);
        sortedList.sort(Comparator.comparing(Object::toString));
        return sortedList;
    }

    private static String setterName(Method getMethod) {
        if (getMethod == null) {
            return null;
        }
        if (getMethod.getName().startsWith("get")) {
            return "set" + getMethod.getName().substring(3);
        }
        if (getMethod.getName().startsWith("is")) {
            return "set" + getMethod.getName().substring(2);
        }
        return null;
    }

    private static Map<FieldId, VisitorPath> filterByFieldType(Map<FieldId, VisitorPath> paths, Class<?> type) {
        return paths.keySet().stream().filter(f -> type.isAssignableFrom(f.getClass())).collect(Collectors.toMap(f -> f, paths::get));
    }

    private static String setterSwitchContent(Map<FieldId, VisitorPath> paths) {
        StringBuilder buffer = new StringBuilder();
        for (FieldId fieldid : ModelWrapperGen.sortFields(paths.keySet())) {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("field.id.name", fieldid.toString());
            buffer.append(MacroProcessor.replaceProperties(Templates.setSwitchBlock, conf));
        }
        return buffer.toString();
    }

    private static String getterSwitchContent(Map<FieldId, VisitorPath> paths) {
        StringBuilder buffer = new StringBuilder();
        for (FieldId fieldId : ModelWrapperGen.sortFields(paths.keySet())) {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("field.id.name", fieldId.toString());
            buffer.append(MacroProcessor.replaceProperties(Templates.getSwitchBlock, conf));
        }
        return buffer.toString();
    }

    private static String setterBoxingChecker(VisitorPath path) {
        Class<?> type = path.getGetMethod().getReturnType();
        if (Integer.TYPE.equals(type) || Double.TYPE.equals(type) || Float.TYPE.equals(type) || Long.TYPE.equals(type) || Short.TYPE.equals(type)) {
            return "value != null ? value : 0";
        }
        if (Boolean.TYPE.equals(type)) {
            return "value != null ? value : false";
        }
        if (Character.TYPE.equals(type)) {
            return "value != null ? value : '\u0000'";
        }
        Type genericReturnType = path.getGetMethod().getGenericReturnType();
        int position = path.getFieldId().position();
        if (List.class.isAssignableFrom(type)) {
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            Type typeArg = parameterizedType.getActualTypeArguments()[0];
            String genericTypeName = ModelWrapperGen.typeName(typeArg);
            if (position != -1) {
                return "value";
            }
            return "value != null ? value : new java.util.ArrayList<" + genericTypeName + ">()";
        }
        return "value";
    }

    static Class<?> getterType(VisitorPath path) {
        return path.getPath().get(path.getPath().size() - 1).getReturnType();
    }

    static String getterBoxingType(VisitorPath path, int position) {
        Method lastMethod = path.getPath().get(path.getPath().size() - 1);
        Type genericReturnType = lastMethod.getGenericReturnType();
        Class<?> type = lastMethod.getReturnType();
        return ModelWrapperGen.boxingType(type, genericReturnType, position);
    }

    static String primitiveBoxingType(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return Integer.class.getSimpleName();
        }
        if (Double.TYPE.equals(type)) {
            return Double.class.getSimpleName();
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class.getSimpleName();
        }
        if (Float.TYPE.equals(type)) {
            return Float.class.getSimpleName();
        }
        if (Long.TYPE.equals(type)) {
            return Long.class.getSimpleName();
        }
        if (Short.TYPE.equals(type)) {
            return Short.class.getSimpleName();
        }
        if (Character.TYPE.equals(type)) {
            return Character.class.getSimpleName();
        }
        return type.getSimpleName();
    }

    static String boxingType(Class<?> type, Type genericReturnType, int position) {
        if (type.isPrimitive()) {
            return ModelWrapperGen.primitiveBoxingType(type);
        }
        if ("java.lang".equals(type.getPackage().getName())) {
            return type.getSimpleName();
        }
        if (List.class.isAssignableFrom(type)) {
            if (position != -1 && genericReturnType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                Type typeArg = parameterizedType.getActualTypeArguments()[0];
                return ModelWrapperGen.typeName(typeArg);
            }
            return genericReturnType.toString();
        }
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            ArrayList<String> typeNames = new ArrayList<String>();
            for (Type typeName : parameterizedType.getActualTypeArguments()) {
                typeNames.add(ModelWrapperGen.typeName(typeName));
            }
            return ModelWrapperGen.typeName(type) + "<" + Joiner.on((String)", ").join(typeNames) + ">";
        }
        return ModelWrapperGen.typeName(type);
    }

    private static String typeName(Type argumentType) {
        if (argumentType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)argumentType;
            Class rawType = (Class)parameterizedType.getRawType();
            List<String> typeParameters = ModelWrapperGen.typeParameters(parameterizedType);
            return rawType.getName() + "<" + Joiner.on((String)",").join(typeParameters) + ">";
        }
        if (argumentType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)argumentType;
            return typeVariable.getName();
        }
        return ((Class)argumentType).getName();
    }

    static List<String> typeParameters(Type genericReturnType) {
        ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
        ArrayList<String> parameterizedTypeName = new ArrayList<String>();
        for (Type paramType : parameterizedType.getActualTypeArguments()) {
            parameterizedTypeName.add(((Class)paramType).getName());
        }
        return parameterizedTypeName;
    }

    private static String setterPath(VisitorPath path) {
        String setMethodName = path.getSetMethod() != null ? path.getSetMethod().getName() : null;
        return ModelWrapperGen.setterPath(path.getPath(), setMethodName, path.getFieldId().position(), true);
    }

    private static String getterPath(VisitorPath path) {
        int index = path.getFieldId().position();
        StringBuilder buffer = new StringBuilder();
        for (Method method : path.getPath()) {
            if (List.class.isAssignableFrom(method.getReturnType()) && index >= 0) {
                buffer.append(method.getName());
                buffer.append("().get(");
                buffer.append(index - 1);
                buffer.append(")");
            } else {
                buffer.append(method.getName());
                buffer.append("()");
            }
            if (path.getPath().indexOf(method) >= path.getPath().size() - 1) continue;
            buffer.append('.');
        }
        return buffer.toString();
    }

    private static String setterPath(List<Method> path, String setMethod, int index, boolean initAtPosition) {
        StringBuilder buffer = new StringBuilder();
        for (Method method : path) {
            if (List.class.isAssignableFrom(method.getReturnType()) && path.indexOf(method) == path.size() - 1) {
                if (initAtPosition && index != -1) {
                    buffer.append(method.getName());
                    buffer.append("().set(").append(index).append(" ,${param})");
                } else {
                    buffer.append(setMethod);
                    buffer.append("(${param})");
                }
            } else if (List.class.isAssignableFrom(method.getReturnType()) && index >= 0) {
                buffer.append(method.getName());
                buffer.append("().get(");
                buffer.append(index - 1);
                buffer.append(")");
            } else if (!Strings.isNullOrEmpty((String)setMethod) && path.indexOf(method) == path.size() - 1) {
                buffer.append(setMethod);
                buffer.append("(${param})");
            } else {
                buffer.append(method.getName());
                buffer.append("()");
            }
            if (path.indexOf(method) >= path.size() - 1) continue;
            buffer.append('.');
        }
        return buffer.toString();
    }

    static String mapConstructors(String targetClassName, Class<? extends FieldModel> baseClazz, Class<?> modelClass) {
        if (AbstractWrapper.class.equals(baseClazz)) {
            return ModelWrapperGen.writeDefaultConstructors(targetClassName, modelClass);
        }
        return Arrays.stream(baseClazz.getDeclaredConstructors()).filter(c -> !Modifier.isPrivate(c.getModifiers())).map(c -> ModelWrapperGen.mapConstructor(targetClassName, c, modelClass)).collect(Collectors.joining());
    }

    private static String writeDefaultConstructors(String targetClassName, Class<?> modelClass) {
        StringBuilder buffer = new StringBuilder();
        List<String> superCall = Arrays.asList("fieldInfos()", "new " + modelClass.getSimpleName() + "()");
        buffer.append(ModelWrapperGen.writeConstructor(targetClassName, Collections.emptyList(), superCall));
        List<String> parameters = Collections.singletonList(modelClass.getSimpleName() + " model");
        superCall = Arrays.asList("fieldInfos()", "model");
        buffer.append(ModelWrapperGen.writeConstructor(targetClassName, parameters, superCall));
        return buffer.toString();
    }

    private static String mapConstructor(String targetClassName, Constructor<?> constructor, Class<?> modelClass) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> parameterTypes = new ArrayList<String>();
        ArrayList<String> superCall = new ArrayList<String>();
        Integer modelParameterIndex = null;
        for (int i = 0; i < constructor.getParameters().length; ++i) {
            Parameter parameter = constructor.getParameters()[i];
            Type type = parameter.getParameterizedType();
            if (ModelWrapperGen.isModelParameter(modelClass, type)) {
                superCall.add("new " + modelClass.getSimpleName() + "()");
                modelParameterIndex = i;
                continue;
            }
            if (ModelWrapperGen.isFieldInfoListParameter(type)) {
                superCall.add("fieldInfos()");
                continue;
            }
            parameterTypes.add(parameter.toString());
            superCall.add(parameter.getName());
        }
        buffer.append(ModelWrapperGen.writeConstructor(targetClassName, parameterTypes, superCall));
        if (modelParameterIndex != null) {
            superCall.set(modelParameterIndex, "model");
            if (parameterTypes.size() > modelParameterIndex) {
                parameterTypes.add(modelParameterIndex, modelClass.getSimpleName() + " model");
            } else {
                parameterTypes.add(modelClass.getSimpleName() + " model");
            }
            buffer.append(ModelWrapperGen.writeConstructor(targetClassName, parameterTypes, superCall));
        }
        return buffer.toString();
    }

    private static boolean isModelParameter(Class<?> modelClass, Type type) {
        return Class.class.isAssignableFrom(type.getClass()) && modelClass.equals(type);
    }

    private static boolean isFieldInfoListParameter(Type type) {
        ParameterizedType parameterizedType;
        if (ParameterizedType.class.isAssignableFrom(type.getClass()) && List.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType()) && parameterizedType.getActualTypeArguments().length == 1) {
            Type parameterType = parameterizedType.getActualTypeArguments()[0];
            return FieldInfo.class.equals((Object)parameterType);
        }
        return false;
    }

    private static String writeConstructor(String targetClassName, List<String> parameters, List<String> superCall) {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("target.class.name", targetClassName);
        conf.put("constructor.parameters", parameters.stream().collect(Collectors.joining(", ")));
        conf.put("constructor.super.call", superCall.stream().collect(Collectors.joining(", ")));
        return MacroProcessor.replaceProperties(Templates.wrapperConstructor, conf);
    }
}

