/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import com.google.common.base.Strings;
import io.doov.core.FieldId;
import io.doov.core.PathConstraint;
import io.doov.gen.ModelVisitor;
import io.doov.gen.VisitorPath;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

final class Visitor {
    private final Class<?> baseClass;
    private final List<VisitorPath> collected;

    Visitor(Class<?> baseClass, List<VisitorPath> collected) {
        this.baseClass = baseClass;
        this.collected = collected;
    }

    void visit(List<ModelVisitor.PathAnnotation> fieldTarget, Method getMethod, Method setMethod, List<Method> paths, boolean _transient) {
        fieldTarget.forEach(annotation -> {
            VisitorPath path;
            if (!Visitor.checkFieldTargetConstraint(paths, annotation.fieldId, annotation.constraint)) {
                return;
            }
            HashMap<String, String> cannonicalReplacement = new HashMap<String, String>();
            if (annotation.constraint.canonicalPathReplacements() != null) {
                cannonicalReplacement.putAll(annotation.constraint.canonicalPathReplacements());
            }
            if (this.contains(path = new VisitorPath(this.baseClass, paths, annotation.fieldId, annotation.readable, getMethod, setMethod, _transient, cannonicalReplacement))) {
                return;
            }
            this.collected.add(path);
        });
    }

    private static boolean checkFieldTargetConstraint(List<Method> paths, FieldId fieldId, PathConstraint constraint) {
        return Strings.isNullOrEmpty((String)constraint.includePath()) || VisitorPath.getterPath(paths, fieldId.position()).contains(constraint.includePath());
    }

    private boolean contains(VisitorPath vPath) {
        String displayPath = vPath.toString();
        return this.collected.stream().anyMatch(path -> path.toString().equals(displayPath));
    }
}

