/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import io.doov.core.FieldId;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class VisitorPath {
    private final Class<?> baseClass;
    private final List<Method> path;
    private final FieldId fieldId;
    private final String readable;
    private final Method getMethod;
    private final Method setMethod;
    private final boolean _transient;
    private final Map<String, String> canonicalReplacement;

    public VisitorPath(Class<?> baseClass, List<Method> getPath, FieldId fieldId, String readable, Method getMethod, Method setMethod, boolean _transient, Map<String, String> canonicalReplacement) {
        this.baseClass = baseClass;
        this.path = new ArrayList<Method>(getPath);
        this.fieldId = fieldId;
        this.readable = readable;
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this._transient = _transient;
        this.canonicalReplacement = canonicalReplacement;
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public List<Method> getPath() {
        return this.path;
    }

    public FieldId getFieldId() {
        return this.fieldId;
    }

    public String getReadable() {
        return this.readable;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public boolean containsList() {
        return this.path.stream().anyMatch(p -> List.class.isAssignableFrom(p.getReturnType()));
    }

    public boolean containsGenerics() {
        return this.path.stream().anyMatch(p -> p.getGenericReturnType().toString().contains("<"));
    }

    public String displayPath() {
        return VisitorPath.getterPath(this.path, this.fieldId.position());
    }

    public String canonicalPath() {
        String displayPath = this.displayPath();
        for (Map.Entry<String, String> entry : this.canonicalReplacement.entrySet()) {
            displayPath = displayPath.replaceAll(entry.getKey(), entry.getValue());
        }
        return displayPath;
    }

    public String toString() {
        return this.baseClass.getSimpleName().toLowerCase() + "." + this.displayPath() + ":" + this.fieldId;
    }

    static String getterPath(List<Method> path) {
        return VisitorPath.getterPath(path, -1);
    }

    static String getterPath(List<Method> path, int index) {
        StringBuilder buffer = new StringBuilder();
        for (Method method : path) {
            if (List.class.isAssignableFrom(method.getReturnType()) && index >= 0) {
                buffer.append(method.getName());
                buffer.append("().get(");
                buffer.append(index - 1);
                buffer.append(")");
            } else {
                buffer.append(method.getName());
                buffer.append("()");
            }
            if (path.indexOf(method) >= path.size() - 1) continue;
            buffer.append('.');
        }
        return buffer.toString();
    }

    static Map<FieldId, List<VisitorPath>> pathByFieldId(List<VisitorPath> paths) {
        HashMap<FieldId, List<VisitorPath>> textPaths = new HashMap<FieldId, List<VisitorPath>>();
        paths.forEach(path -> textPaths.computeIfAbsent(path.getFieldId(), f -> new ArrayList()).add(path));
        textPaths.forEach((fieldId, visitorPaths) -> {
            HashMap pathMap = new HashMap();
            visitorPaths.forEach(p -> pathMap.put(p.toString(), p));
            textPaths.put((FieldId)fieldId, new ArrayList(pathMap.values()));
        });
        textPaths.values().forEach(mappedPaths -> mappedPaths.sort(Comparator.comparing(VisitorPath::toString)));
        return textPaths;
    }
}

