/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import com.google.common.base.CaseFormat;
import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.dsl.field.FieldTypeProvider;
import io.doov.gen.GeneratorFieldInfo;
import io.doov.gen.ModelWrapperGen;
import io.doov.gen.processor.MacroProcessor;
import io.doov.gen.processor.Templates;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class DslMethodsGen {
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    DslMethodsGen() {
    }

    static String imports(Map<FieldId, GeneratorFieldInfo> fieldPaths, FieldTypeProvider typeProvider, List<String> extraImports) {
        return Stream.concat(fieldPaths.entrySet().stream().flatMap(e -> DslMethodsGen.toImports(typeProvider, e)).filter(clazz -> clazz.contains(".")).filter(clazz -> !clazz.contains("java.lang.")), extraImports.stream()).distinct().sorted().map(clazz -> "import " + clazz + ";").collect(Collectors.joining("\n"));
    }

    private static Stream<? extends String> toImports(FieldTypeProvider typeProvider, Map.Entry<FieldId, GeneratorFieldInfo> e) {
        ArrayList<String> imports = new ArrayList<String>();
        GeneratorFieldInfo fieldInfo = e.getValue();
        Class fieldInfoType = typeProvider.fielInfoType((FieldInfo)fieldInfo);
        imports.add(fieldInfoType.getName());
        if (fieldInfoType.getTypeParameters().length > 0) {
            imports.add(fieldInfo.type().getName());
            imports.addAll(Arrays.stream(fieldInfo.genericTypes()).map(Class::getName).collect(Collectors.toSet()));
        }
        return imports.stream();
    }

    static String fields(Map<FieldId, GeneratorFieldInfo> fieldInfos, FieldTypeProvider typeProvider, boolean enumFieldInfo) {
        return fieldInfos.entrySet().stream().sorted(Comparator.comparing(e -> ((FieldId)e.getKey()).code())).map(e -> {
            GeneratorFieldInfo fieldInfo = (GeneratorFieldInfo)((Object)((Object)e.getValue()));
            Class type = fieldInfo.type();
            String rawType = fieldInfo.type().isPrimitive() ? ModelWrapperGen.primitiveBoxingType(type) : type.getSimpleName();
            String genericTypes = DslMethodsGen.formatGenericTypes(fieldInfo.genericTypes());
            Class fieldInfoClass = typeProvider.fielInfoType((FieldInfo)fieldInfo);
            HashMap<String, String> conf = new HashMap<String, String>();
            String fieldType = DslMethodsGen.fieldInfoType(fieldInfoClass, type, rawType, genericTypes);
            conf.put("field.type", fieldType);
            conf.put("field.type.class", fieldInfoClass.getSimpleName() + (fieldType.indexOf(">") > 0 ? "<>" : ""));
            conf.put("field.readable", DslMethodsGen.formatMethod(fieldInfo.readable()));
            conf.put("field.info.ref", fieldInfo.id().toString() + (enumFieldInfo ? ".delegate()" : ""));
            return MacroProcessor.replaceProperties(Templates.dslFieldMethod, conf);
        }).collect(Collectors.joining("\n\n"));
    }

    static String iterableMethods(Map<FieldId, GeneratorFieldInfo> fieldInfos, FieldTypeProvider typeProvider) {
        return fieldInfos.entrySet().stream().filter(e -> ((FieldId)e.getKey()).position() > 0).collect(Collectors.groupingBy(e -> ((GeneratorFieldInfo)((Object)((Object)e.getValue()))).getPath().canonicalPath().replaceAll("[0-9]+", ""))).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getValue).sorted(Comparator.comparing(l -> ((GeneratorFieldInfo)((Object)((Object)((Map.Entry)l.get(0)).getValue()))).readable())).map(fieldInfoList -> {
            GeneratorFieldInfo fieldInfo = (GeneratorFieldInfo)((Object)((Object)((Map.Entry)fieldInfoList.get(0)).getValue()));
            Class type = fieldInfo.type();
            String rawType = type.isPrimitive() ? ModelWrapperGen.primitiveBoxingType(type) : type.getSimpleName();
            String genericTypes = DslMethodsGen.formatGenericTypes(fieldInfo.genericTypes());
            Class fieldInfoClass = typeProvider.fielInfoType((FieldInfo)fieldInfo);
            String fieldType = DslMethodsGen.fieldInfoType(fieldInfoClass, type, rawType, genericTypes);
            String fieldList = fieldInfoList.stream().sorted(Comparator.comparing(f -> ((FieldId)f.getKey()).position())).map(entry -> DslMethodsGen.formatMethod(((GeneratorFieldInfo)((Object)((Object)((Object)entry.getValue())))).readable())).collect(Collectors.joining(", "));
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("field.type", fieldType);
            conf.put("method.name", DslMethodsGen.formatMethod(fieldInfo.readable()).replaceAll("[0-9]+", ""));
            conf.put("field.info.refs", fieldList);
            return MacroProcessor.replaceProperties(Templates.dslFieldIterableMethod, conf);
        }).collect(Collectors.joining("\n\n"));
    }

    private static String fieldInfoType(Class<? extends FieldInfo> infoType, Class<?> type, String rawType, String genericTypes) {
        if (infoType.getTypeParameters().length == 0) {
            return infoType.getSimpleName();
        }
        if (infoType.getTypeParameters().length == 1) {
            return infoType.getSimpleName() + "<" + rawType + (genericTypes.isEmpty() ? "" : "<" + genericTypes + ">") + ">";
        }
        if (infoType.getTypeParameters().length == 2) {
            if (genericTypes.isEmpty()) {
                return infoType.getSimpleName() + "<?, " + rawType + ">";
            }
            return infoType.getSimpleName() + "<" + genericTypes + ", " + rawType + "<" + genericTypes + ">>";
        }
        throw new IllegalStateException("FieldInfo type " + infoType.getName() + "is not compatible with generic types");
    }

    private static String formatGenericTypes(Class<?>[] genericTypes) {
        return Arrays.stream(genericTypes).map(Class::getSimpleName).collect(Collectors.joining(", "));
    }

    private static String formatMethod(String readable) {
        String slug = readable.replace(".", " ").replace(" and ", " ").replace(" the ", " ").replace(" \u00e0 ", " ").replace(" d'", " ").replace(" a ", " ").replace(" l'", " ").replace(" du ", " ").replace(" au ", " ").replace(" en ", " ").replace(" de ", " ").replace(" un ", " ").replace(" la ", " ").replace(" le ", " ").replace(" une ", " ").replace(" aux ", " ").replace(" des ", " ").replace(" pour ", " ").replace(" avec ", " ").replaceAll("( )+", " ");
        String underscore = WHITESPACE.matcher(slug).replaceAll("_");
        String normalized = Normalizer.normalize(underscore, Normalizer.Form.NFD);
        String latin = NONLATIN.matcher(normalized).replaceAll("").toLowerCase(Locale.ENGLISH);
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, latin);
    }
}

