/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen;

import io.doov.core.FieldId;
import io.doov.gen.VisitorPath;
import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

class FieldCsvGen {
    FieldCsvGen() {
    }

    public static void write(File output, Map<FieldId, VisitorPath> fieldPaths) {
        try (FileWriter writter = new FileWriter(output);){
            writter.write("Path;Id;Type\n");
            for (VisitorPath path : fieldPaths.values()) {
                writter.write(FieldCsvGen.toCsv(path));
            }
            for (FieldId field : FieldCsvGen.fieldsWithoutPath(fieldPaths.values())) {
                writter.write("NO_PATH;");
                writter.write(field.toString());
                writter.write(10);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String toCsv(VisitorPath path) {
        return path.getBaseClass().getSimpleName().toLowerCase() + "." + path.displayPath() + ';' + path.getFieldId() + ';' + path.getGetMethod().getReturnType().getSimpleName() + '\n';
    }

    private static Collection<FieldId> fieldsWithoutPath(Collection<VisitorPath> collected) {
        HashSet<FieldId> fields = new HashSet<FieldId>();
        collected.forEach(path -> Collections.addAll(fields, path.getFieldId().getClass().getEnumConstants()));
        collected.forEach(path -> fields.remove(path.getFieldId()));
        return fields;
    }
}

