/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen.processor;

import io.doov.gen.processor.PropertyParsingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MacroProcessor {
    private static final int MAX_DEPTH = 5;
    private static final String REF_PREFIX = "${";
    private static final String REF_SUFFIX = "}";
    private static final String STR_MORE_THAN_0_LEVEL_TO_EXPAND_1 = "There is more than {0} level to expand the property : ''{1}'')";
    private static final String STR_SYNTAX_ERROR_IN_0 = "Syntax error in property: ''{0}''";
    private static final MessageFormat MORE_THAN_0_LEVEL_TO_EXPAND_1 = new MessageFormat("There is more than {0} level to expand the property : ''{1}'')");

    private static String eval(Map<String, Object> conf, String key) {
        String replacement = REF_PREFIX + key + REF_SUFFIX;
        if (conf == null) {
            return replacement;
        }
        Object value = conf.get(key);
        if (value == null) {
            return replacement;
        }
        return value.toString();
    }

    public static String replaceProperties(String value, Map<String, ?> conf) {
        return MacroProcessor.replacePropertiesRec(value, conf, new ArrayList<String>(), new ArrayList<String>(), 0);
    }

    private static String replacePropertiesRec(String value, Map<String, Object> conf, List<String> fragments, List<String> propertyRefs, int depth) {
        MacroProcessor.parsePropertyString(value, fragments, propertyRefs);
        StringBuilder unkownParam = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        Iterator<String> i = fragments.iterator();
        Iterator<String> j = propertyRefs.iterator();
        while (i.hasNext()) {
            String fragment = i.next();
            if (fragment == null) {
                String propertyName = j.next();
                fragment = MacroProcessor.eval(conf, propertyName);
                boolean sameProperty = fragment.contains(REF_PREFIX + propertyName + REF_SUFFIX);
                boolean alwaysProperty = MacroProcessor.containProperty(fragment);
                if (alwaysProperty && !sameProperty) {
                    unkownParam.append(fragment);
                }
            }
            sb.append(fragment);
        }
        boolean containProperty = MacroProcessor.containProperty(unkownParam.toString());
        String expandedValue = sb.toString();
        if (containProperty && depth <= 5) {
            fragments.clear();
            propertyRefs.clear();
            return MacroProcessor.replacePropertiesRec(expandedValue, conf, fragments, propertyRefs, depth + 1);
        }
        if (containProperty && depth > 5) {
            throw new PropertyParsingException(MORE_THAN_0_LEVEL_TO_EXPAND_1.format(new Object[]{5, expandedValue}));
        }
        return expandedValue;
    }

    private static void parsePropertyString(String textToParse, List<String> fragments, List<String> propertyRefs) {
        int pos;
        MessageFormat SYNTAX_ERROR_IN_0 = new MessageFormat(STR_SYNTAX_ERROR_IN_0);
        int prev = 0;
        while ((pos = textToParse.indexOf(36, prev)) >= 0) {
            if (pos > 0) {
                fragments.add(textToParse.substring(prev, pos));
            }
            if (pos == textToParse.length() - 1) {
                fragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (textToParse.charAt(pos + 1) != '{') {
                if (textToParse.charAt(pos + 1) == '$') {
                    fragments.add("$");
                    prev = pos + 2;
                    continue;
                }
                fragments.add(textToParse.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = textToParse.indexOf(125, pos);
            if (endName < 0) {
                throw new PropertyParsingException(SYNTAX_ERROR_IN_0.format(new String[]{textToParse}));
            }
            String propertyName = textToParse.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < textToParse.length()) {
            fragments.add(textToParse.substring(prev));
        }
    }

    private static boolean containProperty(String value) {
        return value.contains(REF_PREFIX);
    }
}

