/*
 * Decompiled with CFR 0.152.
 */
package io.doov.gen.utils;

import io.doov.core.dsl.path.ReadMethodRef;
import io.doov.core.dsl.path.WriteMethodRef;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;

public class ClassUtils {
    private static Object[] primitiveObjects = new Object[]{null, 0, false, 0.0, 0L, Float.valueOf(0.0f), Character.valueOf('\u0000'), (byte)0, (short)0};

    public static <T, R> Method getReferencedMethod(Class<T> clazz, ReadMethodRef<T, R> methodRef) {
        return ClassUtils.findReferencedMethod(clazz, arg_0 -> methodRef.call(arg_0));
    }

    public static <T, A1> Method getReferencedMethod(Class<T> clazz, WriteMethodRef<T, A1> methodRef) {
        return ClassUtils.findReferencedMethod(clazz, t -> {
            RuntimeException e;
            int i = 0;
            do {
                try {
                    methodRef.call(t, primitiveObjects[i]);
                    e = null;
                }
                catch (ClassCastException | NullPointerException throwable) {
                    e = throwable;
                    ++i;
                }
            } while (e != null && i <= primitiveObjects.length);
        });
    }

    private static <T> Method findReferencedMethod(Class<T> clazz, Consumer<T> invoker) {
        AtomicReference ref = new AtomicReference();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
            ref.set(method);
            return null;
        }));
        try {
            invoker.accept(enhancer.create());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Invalid method reference on class [%s]", clazz));
        }
        Method method2 = (Method)ref.get();
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Invalid method reference on class [%s]", clazz));
        }
        return method2;
    }

    public static LinkedHashMap<Class, Method> transformPathToMethod(Class<?> baseClass, List<ReadMethodRef<?, ?>> path) {
        LinkedHashMap<Class, Method> methodPath = new LinkedHashMap<Class, Method>();
        for (ReadMethodRef<?, ?> methodReference : path) {
            baseClass = ClassUtils.extractMethod(baseClass, methodReference, methodPath);
        }
        return methodPath;
    }

    private static Class extractMethod(Class clazz, ReadMethodRef<?, ?> readRef, LinkedHashMap<Class, Method> collected) {
        Method method = ClassUtils.getReferencedMethod(clazz, readRef);
        collected.put(clazz, method);
        if (ParameterizedType.class.isAssignableFrom(method.getGenericReturnType().getClass())) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return method.getReturnType();
    }
}

