/*
 * Decompiled with CFR 0.152.
 */
package io.doov.js.ast;

import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.DefaultOperator;
import io.doov.core.dsl.meta.Element;
import io.doov.core.dsl.meta.LeafMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import io.doov.core.dsl.meta.i18n.ResourceProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class AstJavascriptVisitor
extends AbstractAstVisitor {
    private final OutputStream ops;
    protected final ResourceProvider bundle;
    protected final Locale locale;
    private int parenthese_depth = 0;
    private int start_with_count = 0;
    private int end_with_count = 0;
    private int use_regexp = 0;
    private int is_match = 0;

    public AstJavascriptVisitor(OutputStream ops, ResourceProvider bundle, Locale locale) {
        this.ops = ops;
        this.bundle = bundle;
        this.locale = locale;
    }

    public void startBinary(BinaryMetadata metadata, int depth) {
        this.write("(");
    }

    public void afterChildBinary(BinaryMetadata metadata, Metadata child, boolean hasNext, int depth) {
        if (hasNext) {
            switch ((DefaultOperator)metadata.getOperator()) {
                case and: {
                    this.write(" && ");
                    break;
                }
                case or: {
                    this.write(" || ");
                    break;
                }
                case greater_than: {
                    this.write(" > ");
                    break;
                }
                case greater_or_equals: {
                    this.write(" >= ");
                    break;
                }
                case lesser_than: {
                    this.write(" < ");
                    break;
                }
                case lesser_or_equals: {
                    this.write(" <= ");
                }
                case equals: {
                    this.write(" == ");
                    break;
                }
                case not_equals: {
                    this.write(" != ");
                    break;
                }
            }
        }
    }

    public void endBinary(BinaryMetadata metadata, int depth) {
        this.write(")");
    }

    public void startNary(NaryMetadata metadata, int depth) {
        if (metadata.getOperator() == DefaultOperator.match_none) {
            this.write("!");
        }
        if (metadata.getOperator() == DefaultOperator.count || metadata.getOperator() == DefaultOperator.sum) {
            this.write("[");
        }
        if (metadata.getOperator() == DefaultOperator.min) {
            this.write("Math.min.apply(null,[");
        }
    }

    public void afterChildNary(NaryMetadata metadata, Metadata child, boolean hasNext, int depth) {
        if (hasNext) {
            switch ((DefaultOperator)metadata.getOperator()) {
                case match_any: {
                    this.write(" || ");
                    break;
                }
                case match_all: {
                    this.write(" && ");
                    break;
                }
                case match_none: {
                    this.write(" && !");
                    break;
                }
                case min: 
                case sum: 
                case count: {
                    this.write(", ");
                    break;
                }
            }
        }
    }

    public void endNary(NaryMetadata metadata, int depth) {
        if (metadata.getOperator() == DefaultOperator.count) {
            this.write("].reduce(function(acc,val){if(val){return acc+1;}return acc;},0)");
        }
        if (metadata.getOperator() == DefaultOperator.min) {
            this.write("])");
        }
        if (metadata.getOperator() == DefaultOperator.sum) {
            this.write("].reduce(function(acc,val){ return acc+val;},0)");
        }
    }

    public void startLeaf(LeafMetadata<?> metadata, int depth) {
        ArrayDeque<Element> stack = new ArrayDeque<Element>();
        metadata.elements().forEach(element -> {
            switch (element.getType()) {
                case OPERATOR: {
                    if (element.getReadable() == DefaultOperator.age_at || element.getReadable() == DefaultOperator.as_a_number || element.getReadable() == DefaultOperator.as_string || element.getReadable() == DefaultOperator.before || element.getReadable() == DefaultOperator.before_or_equals || element.getReadable() == DefaultOperator.after || element.getReadable() == DefaultOperator.after_or_equals) {
                        stack.addFirst((Element)element);
                        break;
                    }
                    stack.add((Element)element);
                    break;
                }
                case FIELD: 
                case VALUE: 
                case STRING_VALUE: 
                case TEMPORAL_UNIT: {
                    stack.add((Element)element);
                    break;
                }
                case UNKNOWN: {
                    this.write("/* Unknown " + element.toString() + "*/");
                    break;
                }
                case PARENTHESIS_LEFT: 
                case PARENTHESIS_RIGHT: {
                    this.write("/*" + element.toString() + "*/");
                }
            }
        });
        this.manageStack(stack);
        while (this.parenthese_depth > 0) {
            this.write(")");
            --this.parenthese_depth;
        }
    }

    public void beforeChildUnary(UnaryMetadata metadata, Metadata child, int depth) {
        this.manageOperator((DefaultOperator)metadata.getOperator(), null);
    }

    public void endUnary(UnaryMetadata metadata, int depth) {
        this.write(")");
    }

    private void manageStack(ArrayDeque<Element> stack) {
        while (stack.size() > 0) {
            Element e = stack.pollFirst();
            switch (e.getType()) {
                case FIELD: {
                    this.write(e.toString());
                    break;
                }
                case OPERATOR: {
                    this.manageOperator((DefaultOperator)e.getReadable(), stack);
                    break;
                }
                case VALUE: {
                    if (StringUtils.isNumeric((CharSequence)e.toString())) {
                        this.write(e.toString());
                        break;
                    }
                    this.write("'" + e.toString() + "'");
                    break;
                }
                case STRING_VALUE: {
                    if (this.use_regexp == 1) {
                        String tmp = e.toString();
                        if (this.is_match == 1) {
                            this.is_match = 0;
                        } else {
                            tmp = this.formatRegexp(tmp);
                        }
                        this.write(tmp);
                        if (this.start_with_count > 0) {
                            this.write(".*");
                            --this.start_with_count;
                        } else if (this.end_with_count > 0) {
                            this.write("$");
                            --this.end_with_count;
                        }
                        this.write("/");
                        this.use_regexp = 0;
                        break;
                    }
                    this.write("'" + e.toString() + "'");
                    break;
                }
            }
        }
    }

    private void manageOperator(DefaultOperator element, ArrayDeque<Element> stack) {
        ArrayDeque<Element> stackTmp = new ArrayDeque<Element>();
        switch (element) {
            case rule: 
            case validate: 
            case empty: 
            case as: {
                break;
            }
            case with: {
                this.manageStack(stack);
                break;
            }
            case as_a_number: {
                if (stack.size() <= 0) break;
                this.write("parseInt(");
                this.write(stack.pollFirst().toString());
                this.write(")");
                break;
            }
            case as_string: {
                if (stack.size() <= 0) break;
                this.write("String(" + stack.pollFirst().toString() + ")");
                break;
            }
            case not: {
                this.write("!(");
                break;
            }
            case always_true: {
                this.write("true");
                break;
            }
            case always_false: {
                this.write("false");
                break;
            }
            case times: {
                this.write(" * ");
                break;
            }
            case equals: {
                this.write(" === ");
                stackTmp.add(stack.pollFirst());
                this.manageStack(stackTmp);
                break;
            }
            case not_equals: {
                this.write(" !== ");
                if (stack != null) {
                    this.write(stack.pollFirst().toString());
                    break;
                }
                if (stack == null) break;
                this.write(stack.pollFirst().toString());
                break;
            }
            case is_null: {
                this.write(" === ( null || undefined || \"\" ) ");
                break;
            }
            case is_not_null: {
                this.write(" !== ( null || undefined || \"\" ) ");
                break;
            }
            case minus: {
                this.write(".subtract(" + stack.pollFirst().toString() + ",'" + stack.pollFirst().toString() + "')");
                break;
            }
            case plus: {
                this.write(".add(" + stack.pollFirst() + ",'" + stack.pollFirst().toString() + "')");
                break;
            }
            case after: {
                this.write("moment(" + stack.pollFirst().toString() + ").isAfter(moment(" + stack.pollFirst().toString() + ")");
                ++this.parenthese_depth;
                break;
            }
            case after_or_equals: {
                this.write("moment(" + stack.pollFirst().toString() + ").isSameOrAfter(moment(" + stack.pollFirst().toString() + ")");
                ++this.parenthese_depth;
                break;
            }
            case age_at: {
                this.write("Math.round(Math.abs(moment(");
                stackTmp.add(stack.pollFirst());
                this.manageStack(stackTmp);
                this.formatAgeAtOperator(stack);
                this.write(").diff(");
                this.write("moment(");
                stackTmp.add(stack.pollFirst());
                this.manageStack(stackTmp);
                this.write(")");
                this.formatAgeAtOperator(stack);
                this.write(", 'years')))");
                break;
            }
            case before: {
                this.write("moment(" + stack.pollFirst().toString() + ").isBefore(" + stack.pollFirst().toString());
                ++this.parenthese_depth;
                break;
            }
            case before_or_equals: {
                this.write("moment(" + stack.pollFirst().toString() + ").isSameOrBefore(" + stack.pollFirst().toString());
                ++this.parenthese_depth;
                break;
            }
            case matches: {
                this.write(".match(/");
                ++this.parenthese_depth;
                this.use_regexp = 1;
                this.is_match = 1;
                break;
            }
            case contains: {
                this.write(".contains('");
                this.write(stack.pollFirst().toString());
                this.write("')");
                break;
            }
            case starts_with: {
                this.write(".match(/^");
                ++this.start_with_count;
                ++this.parenthese_depth;
                this.use_regexp = 1;
                break;
            }
            case ends_with: {
                this.write(".match(/.*");
                ++this.end_with_count;
                ++this.parenthese_depth;
                this.use_regexp = 1;
                break;
            }
            case greater_than: {
                this.write(" > ");
                if (stack == null || stack.size() <= 0) break;
                this.write(stack.pollFirst().toString());
                break;
            }
            case greater_or_equals: {
                this.write(" >= ");
                if (stack == null || stack.size() <= 0) break;
                this.write(stack.pollFirst().toString());
                break;
            }
            case is: {
                this.write(" === ");
                break;
            }
            case lesser_than: {
                this.write(" < ");
                if (stack == null || stack.size() <= 0) break;
                this.write(stack.pollFirst().toString());
                break;
            }
            case lesser_or_equals: {
                this.write(" <= ");
                if (stack == null || stack.size() <= 0) break;
                this.write(stack.pollFirst().toString());
                break;
            }
            case has_not_size: {
                this.write(".length != ");
                break;
            }
            case has_size: {
                this.write(".length == ");
                break;
            }
            case is_empty: {
                this.write(".length == 0");
                break;
            }
            case is_not_empty: {
                this.write(".length != 0");
                break;
            }
            case length_is: {
                this.write(".length");
                break;
            }
            case today: {
                this.write("moment()");
                break;
            }
            case today_plus: {
                this.write("moment().add(");
                break;
            }
            case today_minus: {
                this.write("moment().subtract(");
                break;
            }
            case first_day_of_this_month: {
                this.write("moment().startOf('month')");
                break;
            }
            case first_day_of_this_year: {
                this.write("moment().startOf('year')");
                break;
            }
            case last_day_of_this_month: {
                this.write("moment().endOf('month')");
                break;
            }
            case last_day_of_this_year: {
                this.write("moment().endOf('year')");
                break;
            }
            case first_day_of_month: {
                this.write(".startOf('month')");
                break;
            }
            case first_day_of_next_month: {
                this.write("moment().add(1,'month').startOf('month')");
                break;
            }
            case first_day_of_year: {
                this.write(".startOf('year')");
                break;
            }
            case first_day_of_next_year: {
                this.write("moment().add(1,'year').startOf('year')");
                break;
            }
            case last_day_of_month: {
                this.write(".endOf('month')");
                break;
            }
            case last_day_of_year: {
                this.write(".endOf('year')");
                break;
            }
        }
    }

    private void formatAgeAtOperator(ArrayDeque<Element> stack) {
        ArrayDeque<Element> stackTmp = new ArrayDeque<Element>();
        if (stack.getFirst().getReadable() == DefaultOperator.with || stack.getFirst().getReadable() == DefaultOperator.plus || stack.getFirst().getReadable() == DefaultOperator.minus) {
            if (stack.getFirst().getReadable() == DefaultOperator.with) {
                stack.pollFirst();
                stackTmp.add(stack.pollFirst());
                this.manageStack(stackTmp);
            } else {
                Element ope = stack.pollFirst();
                Element duration = stack.pollFirst();
                Element unit = stack.pollFirst();
                stackTmp.add(ope);
                stackTmp.add(duration);
                stackTmp.add(unit);
                this.manageStack(stackTmp);
            }
        }
    }

    public void startWhen(Metadata metadata, int depth) {
        this.write("if(");
    }

    public void endWhen(Metadata metadata, int depth) {
        while (this.parenthese_depth > 0) {
            this.write(")");
            --this.parenthese_depth;
        }
        this.write("){ true;}else{ false;}\n");
    }

    private String formatRegexp(String reg) {
        reg = reg.replace("|", "\\|");
        reg = reg.replace(".", "\\.");
        reg = reg.replace("^", "\\^");
        reg = reg.replace("$", "\\$");
        reg = reg.replace("(", "\\(");
        reg = reg.replace(")", "\\)");
        reg = reg.replace("[", "\\[");
        reg = reg.replace("]", "\\]");
        reg = reg.replace("-", "\\-");
        reg = reg.replace("{", "\\{");
        reg = reg.replace("}", "\\}");
        reg = reg.replace("?", "\\?");
        reg = reg.replace("*", "\\*");
        reg = reg.replace("+", "\\+");
        reg = reg.replace("/", "\\/");
        return reg;
    }

    protected void write(String str) {
        try {
            this.ops.write(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

