/*
 * Decompiled with CFR 0.152.
 */
package examples.drinkwater.drinktracker.model;

import examples.drinkwater.drinktracker.model.Account;
import examples.drinkwater.drinktracker.model.IAccountService;
import java.util.List;
import java.util.UUID;

public class AccountService
implements IAccountService {
    private static javaslang.collection.List<Account> accounts;

    public AccountService() {
        accounts = javaslang.collection.List.empty();
    }

    @Override
    public Account createAccount(String name, String password) throws Exception {
        javaslang.collection.List existing = accounts.filter(a -> a.getAccountName().equals(name)).toList();
        if (existing.size() > 0) {
            throw new Exception("account already exists");
        }
        Account acc = new Account();
        acc.setAccountName(name);
        acc.setAccountPassword(password);
        acc.setAcountId(UUID.randomUUID().toString());
        accounts = accounts.append((Object)acc);
        return acc;
    }

    @Override
    public Account get(String id) {
        return (Account)accounts.filter(a -> a.getAcountId().equals(id)).get();
    }

    @Override
    public Account login(String name, String password) throws Exception {
        javaslang.collection.List acclist = accounts.filter(a -> a.getAccountName().equals(name)).filter(a -> a.getAccountPassword().equals(password)).toList();
        if (acclist.size() == 0) {
            throw new Exception("login failed");
        }
        ((Account)acclist.get()).setAuthenticated(true);
        return (Account)acclist.get();
    }

    @Override
    public void logoff(Account acc) throws Exception {
        acc.setAuthenticated(false);
    }

    @Override
    public boolean isAuthenticated(Account acc) {
        return acc.isAuthenticated();
    }

    @Override
    public List<Account> getAll() {
        return accounts.toJavaList();
    }

    @Override
    public void clearAccounts() {
        accounts = javaslang.collection.List.empty();
    }
}

