/*
 * Decompiled with CFR 0.152.
 */
package examples.drinkwater.drinktracker.model;

import examples.drinkwater.drinktracker.model.Account;
import examples.drinkwater.drinktracker.model.IAccountService;
import examples.drinkwater.drinktracker.model.IDrinkTrackerService;
import examples.drinkwater.drinktracker.model.IWaterVolumeFormatter;
import examples.drinkwater.drinktracker.model.IWaterVolumeRepository;
import java.util.List;

public class DrinkTrackerService
implements IDrinkTrackerService {
    public IWaterVolumeRepository waterVolumeRepository;
    public IWaterVolumeFormatter waterVolumeFormatter;
    public IAccountService accountService;

    public DrinkTrackerService() {
    }

    public DrinkTrackerService(IAccountService accountService, IWaterVolumeRepository waterVolumeRepository, IWaterVolumeFormatter waterVolumeFormatter) {
        this.accountService = accountService;
        this.waterVolumeRepository = waterVolumeRepository;
        this.waterVolumeFormatter = waterVolumeFormatter;
    }

    public IWaterVolumeRepository getWaterVolumeRepository() {
        return this.waterVolumeRepository;
    }

    public void setWaterVolumeRepository(IWaterVolumeRepository waterVolumeRepository) {
        this.waterVolumeRepository = waterVolumeRepository;
    }

    public IWaterVolumeFormatter getWaterVolumeFormatter() {
        return this.waterVolumeFormatter;
    }

    public void setWaterVolumeFormatter(IWaterVolumeFormatter waterVolumeFormatter) {
        this.waterVolumeFormatter = waterVolumeFormatter;
    }

    public IAccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(IAccountService accountService) {
        this.accountService = accountService;
    }

    @Override
    public String saveVolume(Account account, int volume) throws Exception {
        this.checkAuthenticated(account);
        String volumeAsString = Integer.toString(volume);
        while (volumeAsString.length() < 5) {
            volumeAsString = this.waterVolumeFormatter.formatVolume(volumeAsString);
        }
        this.waterVolumeRepository.saveWaterVolume(account, volumeAsString);
        return volumeAsString;
    }

    @Override
    public List<String> getVolumes(Account account) throws Exception {
        this.checkAuthenticated(account);
        return this.waterVolumeRepository.getVolumes(account);
    }

    @Override
    public void clearVolumes(Account account) throws Exception {
        this.checkAuthenticated(account);
        this.waterVolumeRepository.clearVolumes(account);
    }

    private void checkAuthenticated(Account account) throws Exception {
        if (!this.accountService.isAuthenticated(account)) {
            throw new Exception("should authenticate first");
        }
    }
}

