/*
 * Decompiled with CFR 0.152.
 */
package examples.drinkwater.drinktracker.model;

import examples.drinkwater.drinktracker.model.Account;
import examples.drinkwater.drinktracker.model.Constants;
import examples.drinkwater.drinktracker.model.IWaterVolumeRepository;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class WaterVolumeFileRepository
implements IWaterVolumeRepository {
    public String directory;
    Logger logger = Logger.getLogger(WaterVolumeFileRepository.class.getName());

    public WaterVolumeFileRepository() {
    }

    public WaterVolumeFileRepository(String directory) {
        this.directory = directory;
    }

    private static String createPath(String accountId) {
        return "water-volumes-of-" + accountId + ".txt";
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public synchronized void saveWaterVolume(Account account, String volume) {
        try {
            volume = volume + "\n";
            Thread.sleep(Constants.LATENCY);
            Files.write(Paths.get(this.directory, WaterVolumeFileRepository.createPath(account.getAcountId())), volume.getBytes(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized List<String> getVolumes(Account account) {
        ArrayList<String> lines = new ArrayList(0);
        try {
            lines = Files.readAllLines(Paths.get(this.directory, WaterVolumeFileRepository.createPath(account.getAcountId())), Charset.defaultCharset());
        }
        catch (IOException e) {
            this.logger.warning("error while getting volume from repository : " + e.getMessage());
        }
        return lines;
    }

    @Override
    public synchronized void clearVolumes(Account account) {
        try {
            Files.delete(Paths.get(this.directory, WaterVolumeFileRepository.createPath(account.getAcountId())));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

