/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.SessionFactoryFactory;
import jakarta.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.jersey.server.internal.scanning.AnnotationAcceptingListener;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;

public abstract class ScanningHibernateBundle<T>
extends HibernateBundle<T> {
    protected ScanningHibernateBundle(String pckg) {
        this(pckg, new SessionFactoryFactory());
    }

    protected ScanningHibernateBundle(String pckg, SessionFactoryFactory sessionFactoryFactory) {
        this(new String[]{pckg}, sessionFactoryFactory);
    }

    protected ScanningHibernateBundle(String[] pckgs, SessionFactoryFactory sessionFactoryFactory) {
        super(ScanningHibernateBundle.findEntityClassesFromDirectory(pckgs), sessionFactoryFactory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> findEntityClassesFromDirectory(String[] pckgs) {
        AnnotationAcceptingListener asl = new AnnotationAcceptingListener(new Class[]{Entity.class});
        PackageNamesScanner scanner = new PackageNamesScanner(pckgs, true);
        block12: while (true) {
            while (scanner.hasNext()) {
                String next = scanner.next();
                if (!asl.accept(next)) continue;
                try {
                    InputStream in = scanner.open();
                    try {
                        asl.process(next, in);
                        continue block12;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        continue block12;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("AnnotationAcceptingListener failed to process scanned resource: " + next);
                    return new ArrayList(asl.getAnnotatedClasses());
                }
            }
        }
        finally {
            scanner.close();
        }
    }
}

