/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.hibernate.UnitOfWork;
import io.dropwizard.hibernate.dual.DualSessionFactory;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class UnitOfWorkAspect {
    private final Map<String, SessionFactory> sessionFactories;
    private @Nullable UnitOfWork unitOfWork;
    private @Nullable Session session;
    private @Nullable SessionFactory sessionFactory;
    private boolean sessionCreated;
    private boolean transactionStarted;

    public UnitOfWorkAspect(Map<String, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
    }

    public void beforeStart(@Nullable UnitOfWork unitOfWork) {
        if (unitOfWork == null) {
            return;
        }
        this.unitOfWork = unitOfWork;
        this.sessionFactory = this.sessionFactories.get(unitOfWork.value());
        if (this.sessionFactory == null) {
            if (unitOfWork.value().equals("hibernate") && this.sessionFactories.size() == 1) {
                this.sessionFactory = this.sessionFactories.values().iterator().next();
            } else {
                throw new IllegalArgumentException("Unregistered Hibernate bundle: '" + unitOfWork.value() + "'");
            }
        }
        if (this.sessionFactory instanceof DualSessionFactory) {
            ((DualSessionFactory)this.sessionFactory).prepare(unitOfWork.readOnly());
        }
        Session existingSession = null;
        if (ManagedSessionContext.hasBind((SessionFactory)this.sessionFactory)) {
            existingSession = this.sessionFactory.getCurrentSession();
        }
        if (existingSession != null) {
            this.sessionCreated = false;
            this.session = existingSession;
            this.validateSession();
        } else {
            this.sessionCreated = true;
            this.session = this.sessionFactory.openSession();
            try {
                this.configureSession();
                ManagedSessionContext.bind((Session)this.session);
            }
            catch (Throwable th) {
                this.session.close();
                this.session = null;
                ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
                throw th;
            }
        }
        this.beginTransaction(unitOfWork, this.session);
    }

    public void afterEnd() {
        if (this.unitOfWork == null || this.session == null) {
            return;
        }
        try {
            this.commitTransaction(this.unitOfWork, this.session);
        }
        catch (Exception e) {
            this.rollbackTransaction(this.unitOfWork, this.session);
            throw e;
        }
    }

    public void onError() {
        if (this.unitOfWork == null || this.session == null) {
            return;
        }
        try {
            this.rollbackTransaction(this.unitOfWork, this.session);
        }
        finally {
            this.onFinish();
        }
    }

    public void onFinish() {
        try {
            if (this.sessionCreated && this.session != null) {
                this.session.close();
            }
        }
        finally {
            this.session = null;
            if (this.sessionCreated) {
                ManagedSessionContext.unbind((SessionFactory)this.sessionFactory);
            }
        }
    }

    protected void configureSession() {
        if (this.unitOfWork == null || this.session == null) {
            throw new NullPointerException("unitOfWork or session is null. This is a bug!");
        }
        this.session.setDefaultReadOnly(this.unitOfWork.readOnly());
        this.session.setCacheMode(this.unitOfWork.cacheMode());
        this.session.setHibernateFlushMode(this.unitOfWork.flushMode());
    }

    protected void validateSession() {
        if (this.unitOfWork == null || this.session == null) {
            throw new NullPointerException("unitOfWork or session is null. This is a bug!");
        }
        if (this.unitOfWork.readOnly() != this.session.isDefaultReadOnly()) {
            throw new IllegalStateException(String.format("Existing session readOnly state (%b) does not match requested state (%b)", this.session.isDefaultReadOnly(), this.unitOfWork.readOnly()));
        }
        if (this.unitOfWork.cacheMode() != this.session.getCacheMode()) {
            throw new IllegalStateException(String.format("Existing session cache mode (%s) does not match requested mode (%s)", this.session.getCacheMode(), this.unitOfWork.cacheMode()));
        }
        if (this.unitOfWork.flushMode() != this.session.getHibernateFlushMode()) {
            throw new IllegalStateException(String.format("Existing session flush mode (%s) does not match requested mode (%s)", this.session.getHibernateFlushMode(), this.unitOfWork.flushMode()));
        }
    }

    private void beginTransaction(UnitOfWork unitOfWork, Session session) {
        if (!unitOfWork.transactional()) {
            return;
        }
        Transaction txn = session.getTransaction();
        if (txn != null && txn.isActive()) {
            this.transactionStarted = false;
        } else {
            session.beginTransaction();
            this.transactionStarted = true;
        }
    }

    private void rollbackTransaction(UnitOfWork unitOfWork, Session session) {
        if (!unitOfWork.transactional()) {
            return;
        }
        Transaction txn = session.getTransaction();
        if (this.transactionStarted && txn != null && txn.getStatus().canRollback()) {
            txn.rollback();
        }
    }

    private void commitTransaction(UnitOfWork unitOfWork, Session session) {
        if (!unitOfWork.transactional()) {
            return;
        }
        Transaction txn = session.getTransaction();
        if (this.transactionStarted && txn != null && txn.getStatus().canRollback()) {
            txn.commit();
        }
    }

    protected Session getSession() {
        return Objects.requireNonNull(this.session);
    }

    protected SessionFactory getSessionFactory() {
        return Objects.requireNonNull(this.sessionFactory);
    }
}

