/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.UnitOfWork;
import io.dropwizard.hibernate.UnitOfWorkAspect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.SessionFactory;

public class UnitOfWorkAwareProxyFactory {
    private final Map<String, SessionFactory> sessionFactories;
    private final LoadingCache<Class<?>, Class<?>> proxyCache;

    public UnitOfWorkAwareProxyFactory(String name, SessionFactory sessionFactory) {
        this((Caffeine<Object, Object>)Caffeine.newBuilder(), name, sessionFactory);
    }

    public UnitOfWorkAwareProxyFactory(Caffeine<Object, Object> proxyCacheBuilder, String name, SessionFactory sessionFactory) {
        this.sessionFactories = Collections.singletonMap(name, sessionFactory);
        this.proxyCache = this.buildCache(proxyCacheBuilder);
    }

    public UnitOfWorkAwareProxyFactory(HibernateBundle<?> ... bundles) {
        this((Caffeine<Object, Object>)Caffeine.newBuilder(), bundles);
    }

    public UnitOfWorkAwareProxyFactory(Caffeine<Object, Object> proxyCacheBuilder, HibernateBundle<?> ... bundles) {
        HashMap<String, SessionFactory> sessionFactoriesBuilder = new HashMap<String, SessionFactory>();
        for (HibernateBundle<?> bundle : bundles) {
            sessionFactoriesBuilder.put(bundle.name(), bundle.getSessionFactory());
        }
        this.sessionFactories = Collections.unmodifiableMap(sessionFactoriesBuilder);
        this.proxyCache = this.buildCache(proxyCacheBuilder);
    }

    private LoadingCache<Class<?>, Class<?>> buildCache(Caffeine<Object, Object> proxyCacheBuilder) {
        return proxyCacheBuilder.build(new CacheLoader<Class<?>, Class<?>>(){

            public Class<?> load(@NonNull Class<?> key) {
                return UnitOfWorkAwareProxyFactory.this.createProxyClass(key);
            }
        });
    }

    public <T> T create(Class<T> clazz) {
        return this.create(clazz, new Class[0], new Object[0]);
    }

    public <T> T create(Class<T> clazz, Class<?> constructorParamType, Object constructorArguments) {
        return this.create(clazz, new Class[]{constructorParamType}, new Object[]{constructorArguments});
    }

    public <T> T create(Class<T> clazz, Class<?>[] constructorParamTypes, Object[] constructorArguments) {
        Class proxied = (Class)this.proxyCache.get(clazz);
        try {
            return constructorParamTypes.length == 0 ? proxied.getConstructor(new Class[0]).newInstance(new Object[0]) : proxied.getConstructor(constructorParamTypes).newInstance(constructorArguments);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create a proxy for the class '" + clazz + "'", e);
        }
    }

    protected <T> Class<? extends T> createProxyClass(Class<T> classToProxy) {
        return new ByteBuddy().subclass(classToProxy).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.to((Object)new MethodInterceptor(this.sessionFactories))).make().load(classToProxy.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    public UnitOfWorkAspect newAspect() {
        return new UnitOfWorkAspect(this.sessionFactories);
    }

    public UnitOfWorkAspect newAspect(Map<String, SessionFactory> sessionFactories) {
        return new UnitOfWorkAspect(sessionFactories);
    }

    public class MethodInterceptor {
        private final Map<String, SessionFactory> sessionFactories;

        public MethodInterceptor(Map<String, SessionFactory> sessionFactories) {
            this.sessionFactories = sessionFactories;
        }

        @RuntimeType
        public Object invoke(@Origin Method overridden, @SuperCall Callable<Object> proxy) throws Throwable {
            Map<Object, Object> unitOfWorkAspectMap;
            UnitOfWork[] unitsOfWork = (UnitOfWork[])overridden.getAnnotationsByType(UnitOfWork.class);
            if (unitsOfWork.length == 0) {
                return proxy.call();
            }
            if (unitsOfWork.length == 1) {
                unitOfWorkAspectMap = Collections.singletonMap(unitsOfWork[0], UnitOfWorkAwareProxyFactory.this.newAspect(this.sessionFactories));
            } else {
                unitOfWorkAspectMap = new HashMap();
                Arrays.stream(unitsOfWork).collect(Collectors.toMap(UnitOfWork::value, Function.identity(), (first, second) -> second)).values().forEach(unitOfWork -> unitOfWorkAspectMap.put(unitOfWork, UnitOfWorkAwareProxyFactory.this.newAspect(this.sessionFactories)));
            }
            try {
                unitOfWorkAspectMap.forEach((unitOfWork, unitOfWorkAspect) -> unitOfWorkAspect.beforeStart((UnitOfWork)unitOfWork));
                Object result = proxy.call();
                unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::afterEnd);
                Object object = result;
                return object;
            }
            catch (InvocationTargetException e) {
                unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::onError);
                throw e.getCause();
            }
            catch (Exception e) {
                unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::onError);
                throw e;
            }
            finally {
                unitOfWorkAspectMap.values().forEach(UnitOfWorkAspect::onFinish);
            }
        }
    }
}

