/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.jdbi.InstrumentedTimingCollector;
import com.codahale.metrics.jdbi.strategies.DelegatingStatementNameStrategy;
import com.codahale.metrics.jdbi.strategies.NameStrategies;
import com.codahale.metrics.jdbi.strategies.StatementNameStrategy;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi.DBIHealthCheck;
import io.dropwizard.jdbi.GuavaOptionalContainerFactory;
import io.dropwizard.jdbi.ImmutableListContainerFactory;
import io.dropwizard.jdbi.ImmutableSetContainerFactory;
import io.dropwizard.jdbi.NamePrependingStatementRewriter;
import io.dropwizard.jdbi.OptionalContainerFactory;
import io.dropwizard.jdbi.args.GuavaOptionalArgumentFactory;
import io.dropwizard.jdbi.args.GuavaOptionalInstantArgumentFactory;
import io.dropwizard.jdbi.args.GuavaOptionalJodaTimeArgumentFactory;
import io.dropwizard.jdbi.args.GuavaOptionalLocalDateArgumentFactory;
import io.dropwizard.jdbi.args.GuavaOptionalLocalDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.GuavaOptionalOffsetTimeArgumentFactory;
import io.dropwizard.jdbi.args.GuavaOptionalZonedTimeArgumentFactory;
import io.dropwizard.jdbi.args.InstantArgumentFactory;
import io.dropwizard.jdbi.args.InstantMapper;
import io.dropwizard.jdbi.args.JodaDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.JodaDateTimeMapper;
import io.dropwizard.jdbi.args.LocalDateArgumentFactory;
import io.dropwizard.jdbi.args.LocalDateMapper;
import io.dropwizard.jdbi.args.LocalDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.LocalDateTimeMapper;
import io.dropwizard.jdbi.args.OffsetDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.OffsetDateTimeMapper;
import io.dropwizard.jdbi.args.OptionalArgumentFactory;
import io.dropwizard.jdbi.args.OptionalDoubleArgumentFactory;
import io.dropwizard.jdbi.args.OptionalDoubleMapper;
import io.dropwizard.jdbi.args.OptionalInstantArgumentFactory;
import io.dropwizard.jdbi.args.OptionalIntArgumentFactory;
import io.dropwizard.jdbi.args.OptionalIntMapper;
import io.dropwizard.jdbi.args.OptionalJodaTimeArgumentFactory;
import io.dropwizard.jdbi.args.OptionalLocalDateArgumentFactory;
import io.dropwizard.jdbi.args.OptionalLocalDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.OptionalLongArgumentFactory;
import io.dropwizard.jdbi.args.OptionalLongMapper;
import io.dropwizard.jdbi.args.OptionalOffsetDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.OptionalZonedDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.ZonedDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.ZonedDateTimeMapper;
import io.dropwizard.jdbi.logging.LogbackLog;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.util.Optional;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.slf4j.LoggerFactory;

public class DBIFactory {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(DBI.class);
    private static final String RAW_SQL = MetricRegistry.name(DBI.class, (String[])new String[]{"raw-sql"});

    protected Optional<TimeZone> databaseTimeZone() {
        return Optional.empty();
    }

    public DBI build(Environment environment, PooledDataSourceFactory configuration, String name) {
        ManagedDataSource dataSource = configuration.build(environment.metrics(), name);
        return this.build(environment, configuration, dataSource, name);
    }

    public DBI build(Environment environment, PooledDataSourceFactory configuration, ManagedDataSource dataSource, String name) {
        String validationQuery = configuration.getValidationQuery();
        DBI dbi = new DBI((DataSource)dataSource);
        environment.lifecycle().manage((Managed)dataSource);
        environment.healthChecks().register(name, (HealthCheck)new DBIHealthCheck(environment.getHealthCheckExecutorService(), configuration.getValidationQueryTimeout().orElseGet(() -> Duration.seconds((long)5L)), dbi, validationQuery));
        dbi.setSQLLog((SQLLog)new LogbackLog(LOGGER, Level.TRACE));
        dbi.setTimingCollector((TimingCollector)new InstrumentedTimingCollector(environment.metrics(), (StatementNameStrategy)new SanerNamingStrategy()));
        if (configuration.isAutoCommentsEnabled()) {
            dbi.setStatementRewriter((StatementRewriter)new NamePrependingStatementRewriter((StatementRewriter)new ColonPrefixNamedParamStatementRewriter()));
        }
        dbi.registerArgumentFactory((ArgumentFactory)new GuavaOptionalArgumentFactory(configuration.getDriverClass()));
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalArgumentFactory(configuration.getDriverClass()));
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalDoubleArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalIntArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalLongArgumentFactory());
        dbi.registerColumnMapper((ResultColumnMapper)new OptionalDoubleMapper());
        dbi.registerColumnMapper((ResultColumnMapper)new OptionalIntMapper());
        dbi.registerColumnMapper((ResultColumnMapper)new OptionalLongMapper());
        dbi.registerContainerFactory((ContainerFactory)new ImmutableListContainerFactory());
        dbi.registerContainerFactory((ContainerFactory)new ImmutableSetContainerFactory());
        dbi.registerContainerFactory((ContainerFactory)new GuavaOptionalContainerFactory());
        dbi.registerContainerFactory((ContainerFactory)new OptionalContainerFactory());
        Optional<TimeZone> timeZone = this.databaseTimeZone();
        dbi.registerArgumentFactory((ArgumentFactory)new JodaDateTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new LocalDateArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new LocalDateTimeArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new InstantArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new OffsetDateTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new ZonedDateTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new GuavaOptionalJodaTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new GuavaOptionalLocalDateArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new GuavaOptionalLocalDateTimeArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new GuavaOptionalInstantArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new GuavaOptionalOffsetTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new GuavaOptionalZonedTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalJodaTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalLocalDateArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalLocalDateTimeArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalInstantArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalOffsetDateTimeArgumentFactory(timeZone));
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalZonedDateTimeArgumentFactory(timeZone));
        dbi.registerColumnMapper((ResultColumnMapper)new JodaDateTimeMapper(timeZone));
        dbi.registerColumnMapper((ResultColumnMapper)new InstantMapper(timeZone));
        dbi.registerColumnMapper((ResultColumnMapper)new LocalDateMapper());
        dbi.registerColumnMapper((ResultColumnMapper)new LocalDateTimeMapper());
        dbi.registerColumnMapper((ResultColumnMapper)new OffsetDateTimeMapper());
        dbi.registerColumnMapper((ResultColumnMapper)new ZonedDateTimeMapper());
        return dbi;
    }

    private static class SanerNamingStrategy
    extends DelegatingStatementNameStrategy {
        private SanerNamingStrategy() {
            super(new StatementNameStrategy[]{NameStrategies.CHECK_EMPTY, NameStrategies.CONTEXT_CLASS, NameStrategies.CONTEXT_NAME, NameStrategies.SQL_OBJECT, statementContext -> RAW_SQL});
        }
    }
}

