/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbFastForwardCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private PrintStream printStream = System.out;

    protected DbFastForwardCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super("fast-forward", "Mark the next pending change set as applied without running it", strategy, configurationClass, migrationsFileName);
    }

    void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-n", "--dry-run"}).action((ArgumentAction)Arguments.storeTrue()).dest("dry-run").setDefault((Object)Boolean.FALSE).help("output the DDL to stdout, don't run it");
        subparser.addArgument(new String[]{"-a", "--all"}).action((ArgumentAction)Arguments.storeTrue()).dest("all").setDefault((Object)Boolean.FALSE).help("mark all pending change sets as applied");
        subparser.addArgument(new String[]{"-i", "--include"}).action((ArgumentAction)Arguments.append()).dest("contexts").help("include change sets from the given context");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        String context = this.getContext(namespace);
        if (namespace.getBoolean("all").booleanValue()) {
            if (namespace.getBoolean("dry-run").booleanValue()) {
                liquibase.changeLogSync(context, (Writer)new OutputStreamWriter((OutputStream)this.printStream, StandardCharsets.UTF_8));
            } else {
                liquibase.changeLogSync(context);
            }
        } else if (namespace.getBoolean("dry-run").booleanValue()) {
            liquibase.markNextChangeSetRan(context, (Writer)new OutputStreamWriter((OutputStream)this.printStream, StandardCharsets.UTF_8));
        } else {
            liquibase.markNextChangeSetRan(context);
        }
    }

    private String getContext(Namespace namespace) {
        List contexts = namespace.getList("contexts");
        if (contexts == null) {
            return "";
        }
        return contexts.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

