/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.elasticsearch.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.net.HostAndPort;
import io.dropwizard.validation.ValidationMethod;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class EsConfiguration {
    @JsonProperty
    @NotNull
    private List<HostAndPort> servers = Collections.emptyList();
    @JsonProperty
    @NotEmpty
    private String clusterName = "elasticsearch";
    @JsonProperty
    private boolean nodeClient = true;
    @JsonProperty
    @NotNull
    private Map<String, String> settings = Collections.emptyMap();
    @JsonProperty
    private String settingsFile = null;

    public List<HostAndPort> getServers() {
        return this.servers;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean isNodeClient() {
        return this.nodeClient;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getSettingsFile() {
        return this.settingsFile;
    }

    @ValidationMethod
    @JsonIgnore
    public boolean isValidConfig() {
        return this.nodeClient || !this.servers.isEmpty();
    }
}

