/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.elasticsearch.health;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.client.Client;

public class EsIndexDocsHealthCheck
extends HealthCheck {
    private static final String HEALTH_CHECK_NAME = "elasticsearch-index-documents";
    private static final long DEFAULT_DOCUMENT_THRESHOLD = 1L;
    private final Client client;
    private final String[] indices;
    private final long documentThreshold;

    public EsIndexDocsHealthCheck(Client client, List<String> indices, long documentThreshold) {
        Preconditions.checkArgument((!indices.isEmpty() ? 1 : 0) != 0, (Object)"At least one index must be given");
        Preconditions.checkArgument((documentThreshold > 0L ? 1 : 0) != 0, (Object)"The document threshold must at least be 1");
        this.client = (Client)Preconditions.checkNotNull((Object)client);
        this.indices = (String[])Preconditions.checkNotNull((Object)indices.toArray(new String[indices.size()]));
        this.documentThreshold = documentThreshold;
    }

    public EsIndexDocsHealthCheck(Client client, List<String> indices) {
        this(client, indices, 1L);
    }

    public EsIndexDocsHealthCheck(Client client, String indexName, long documentThreshold) {
        this(client, (List<String>)ImmutableList.of((Object)indexName), documentThreshold);
    }

    public EsIndexDocsHealthCheck(Client client, String indexName) {
        this(client, indexName, 1L);
    }

    protected HealthCheck.Result check() throws Exception {
        IndicesStatsResponse indicesStatsResponse = (IndicesStatsResponse)this.client.admin().indices().prepareStats(this.indices).get();
        ArrayList<String> indexDetails = new ArrayList<String>(this.indices.length);
        boolean healthy = true;
        for (IndexStats indexStats : indicesStatsResponse.getIndices().values()) {
            long documentCount = indexStats.getPrimaries().getDocs().getCount();
            if (documentCount < this.documentThreshold) {
                healthy = false;
                indexDetails.add(String.format("%s (%d)", indexStats.getIndex(), documentCount));
                continue;
            }
            indexDetails.add(String.format("%s (%d!)", indexStats.getIndex(), documentCount));
        }
        String resultDetails = String.format("Last stats: %s", indexDetails);
        if (healthy) {
            return HealthCheck.Result.healthy((String)resultDetails);
        }
        return HealthCheck.Result.unhealthy((String)resultDetails);
    }
}

