/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.elasticsearch.health;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;

public class EsIndexExistsHealthCheck
extends HealthCheck {
    private final Client client;
    private final String[] indices;

    public EsIndexExistsHealthCheck(Client client, List<String> indices) {
        Preconditions.checkArgument((!indices.isEmpty() ? 1 : 0) != 0, (Object)"At least one index must be given");
        this.client = (Client)Preconditions.checkNotNull((Object)client);
        this.indices = (String[])Preconditions.checkNotNull((Object)indices.toArray(new String[indices.size()]));
    }

    public EsIndexExistsHealthCheck(Client client, String indexName) {
        this(client, (List<String>)ImmutableList.of((Object)indexName));
    }

    protected HealthCheck.Result check() throws Exception {
        IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)this.client.admin().indices().prepareExists(this.indices).get();
        if (indicesExistsResponse.isExists()) {
            return HealthCheck.Result.healthy();
        }
        return HealthCheck.Result.unhealthy((String)"One or more indices do not exist.");
    }
}

