/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.elasticsearch.util;

import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import java.util.List;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class TransportAddressHelper {
    private static final int DEFAULT_PORT = 9300;

    public static TransportAddress fromHostAndPort(HostAndPort hostAndPort) {
        InetSocketAddress address = new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPortOrDefault(9300));
        return new InetSocketTransportAddress(address);
    }

    public static TransportAddress[] fromHostAndPorts(List<HostAndPort> hostAndPorts) {
        if (hostAndPorts == null) {
            return new TransportAddress[0];
        }
        TransportAddress[] transportAddresses = new TransportAddress[hostAndPorts.size()];
        for (int i = 0; i < hostAndPorts.size(); ++i) {
            transportAddresses[i] = TransportAddressHelper.fromHostAndPort(hostAndPorts.get(i));
        }
        return transportAddresses;
    }
}

