/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb;

import com.apple.foundationdb.Database;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.foundationdb.FoundationDBFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class FoundationDBBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    @Nullable
    private Database database;
    @Nullable
    private final Executor executor;

    protected FoundationDBBundle() {
        this(null);
    }

    protected FoundationDBBundle(@Nullable Executor executor) {
        this.executor = executor;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        FoundationDBFactory foundationDBFactory = Objects.requireNonNull(this.getFoundationDBFactory(configuration));
        this.database = Objects.requireNonNull(foundationDBFactory.build(environment.metrics(), environment.lifecycle(), environment.healthChecks(), this.executor));
    }

    public abstract FoundationDBFactory getFoundationDBFactory(T var1);

    public Database getDatabase() {
        return Objects.requireNonNull(this.database);
    }
}

