/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.foundationdb.health.FoundationDBHealthCheck;
import io.dropwizard.foundationdb.instrumented.InstrumentedDatabase;
import io.dropwizard.foundationdb.managed.FoundationDBManager;
import io.dropwizard.foundationdb.security.SecurityFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoundationDBFactory {
    private static final Logger log = LoggerFactory.getLogger(FoundationDBFactory.class);
    @NotEmpty
    @JsonProperty
    private String name = "FoundationDB";
    @Min(value=100L)
    @JsonProperty
    private @Min(value=100L) int apiVersion = 600;
    @NotEmpty
    @JsonProperty
    private String clusterFilePath;
    @NotEmpty
    @JsonProperty
    private String dataCenter;
    @Valid
    @JsonProperty
    private Optional<SecurityFactory> security = Optional.empty();
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) int healthCheckRetries = 5;
    @NotNull
    @JsonProperty
    private Duration healthCheckTimeout = Duration.seconds((long)5L);
    @NotNull
    @JsonProperty
    private String healthCheckSubspace = "health-checking";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getClusterFilePath() {
        return this.clusterFilePath;
    }

    public void setClusterFilePath(String clusterFilePath) {
        this.clusterFilePath = clusterFilePath;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    public Optional<SecurityFactory> getSecurity() {
        return this.security;
    }

    public void setSecurity(Optional<SecurityFactory> security) {
        this.security = security;
    }

    public int getHealthCheckRetries() {
        return this.healthCheckRetries;
    }

    public void setHealthCheckRetries(int healthCheckRetries) {
        this.healthCheckRetries = healthCheckRetries;
    }

    public Duration getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(Duration healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public String getHealthCheckSubspace() {
        return this.healthCheckSubspace;
    }

    public void setHealthCheckSubspace(String healthCheckSubspace) {
        this.healthCheckSubspace = healthCheckSubspace;
    }

    public Database build(MetricRegistry metrics, LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks) {
        return this.build(metrics, lifecycle, healthChecks, FDB.DEFAULT_EXECUTOR);
    }

    public Database build(MetricRegistry metrics, LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, Executor executor) {
        Executor actualExecutor = executor != null ? executor : FDB.DEFAULT_EXECUTOR;
        String absoluteClusterFilePath = new File(this.clusterFilePath).getAbsolutePath();
        FDB fdb = FDB.selectAPIVersion((int)this.apiVersion);
        this.security.filter(SecurityFactory::isEnabled).ifPresent(securityConf -> securityConf.addSecurityConfigurations(fdb.options()));
        Database database = this.buildDatabase(fdb, absoluteClusterFilePath, actualExecutor);
        Database instrumentedDatabase = this.instrumentDatabase(database, metrics);
        instrumentedDatabase.options().setDatacenterId(this.dataCenter);
        this.registerHealthCheck(healthChecks, database);
        this.manageDatabase(lifecycle, fdb);
        log.info("Finished setting up fdbDatabase={}", (Object)this.name);
        return instrumentedDatabase;
    }

    protected Database buildDatabase(FDB fdb, String absoluteClusterFilePath, Executor executor) {
        return fdb.open(absoluteClusterFilePath, executor);
    }

    protected Database instrumentDatabase(Database database, MetricRegistry metrics) {
        return new InstrumentedDatabase(database, metrics, this.name);
    }

    protected void registerHealthCheck(HealthCheckRegistry healthChecks, Database database) {
        FoundationDBHealthCheck healthCheck = new FoundationDBHealthCheck(database, this.name, this.healthCheckSubspace, this.healthCheckTimeout, this.healthCheckRetries);
        healthChecks.register(this.name, (HealthCheck)healthCheck);
    }

    protected void manageDatabase(LifecycleEnvironment lifecycle, FDB fdb) {
        lifecycle.manage((Managed)new FoundationDBManager(fdb, this.name));
    }
}

