/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb;

import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.foundationdb.RecordLayerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class RecordLayerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    @Nullable
    private FDBDatabase database;
    @Nullable
    private final Executor networkExecutor;
    @Nullable
    private final Executor executor;

    protected RecordLayerBundle() {
        this(null, null);
    }

    protected RecordLayerBundle(@Nullable Executor networkExecutor, @Nullable Executor executor) {
        this.networkExecutor = networkExecutor;
        this.executor = executor;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        RecordLayerFactory recordLayerFactory = Objects.requireNonNull(this.getRecordLayerFactory(configuration));
        this.database = Objects.requireNonNull(recordLayerFactory.build(environment.metrics(), environment.lifecycle(), environment.healthChecks(), this.networkExecutor, this.executor));
    }

    public abstract RecordLayerFactory getRecordLayerFactory(T var1);

    public FDBDatabase getDatabase() {
        return Objects.requireNonNull(this.database);
    }
}

