/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb;

import com.apple.foundationdb.FDB;
import com.apple.foundationdb.record.logging.CompletionExceptionLogHelper;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.record.provider.foundationdb.FDBReverseDirectoryCache;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.foundationdb.health.FoundationDBHealthCheck;
import io.dropwizard.foundationdb.instrumented.InstrumentedFDBDatabase;
import io.dropwizard.foundationdb.managed.RecordLayerManager;
import io.dropwizard.foundationdb.security.SecurityFactory;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.util.Duration;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordLayerFactory {
    private static final Logger log = LoggerFactory.getLogger(RecordLayerFactory.class);
    @NotEmpty
    @JsonProperty
    private String name = "RecordLayer";
    @Min(value=100L)
    @JsonProperty
    private @Min(value=100L) int apiVersion = 600;
    @NotEmpty
    @JsonProperty
    private String clusterFilePath;
    @Min(value=1L)
    @JsonProperty
    private @Min(value=1L) int maxRetriableTransactionAttempts = 10;
    @NotNull
    @JsonProperty
    private Duration initialTransactionRetryDelay = Duration.milliseconds((long)10L);
    @NotNull
    @JsonProperty
    private Duration maxTransactionRetryDelay = Duration.seconds((long)1L);
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) int directoryCacheSize = 0;
    @NotNull
    @JsonProperty
    private Duration reverseDirectoryMaxTimePerTransaction = Duration.milliseconds((long)FDBReverseDirectoryCache.MAX_MILLIS_PER_TRANSACTION);
    @JsonProperty
    private int reverseDirectoryMaxRowsPerTransaction = 10000;
    @JsonProperty
    private String traceDirectory = null;
    @JsonProperty
    private String traceLogGroup = null;
    @NotEmpty
    @JsonProperty
    private String dataCenter;
    @Valid
    @JsonProperty
    private Optional<SecurityFactory> security = Optional.empty();
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) int healthCheckRetries = 5;
    @NotNull
    @JsonProperty
    private Duration healthCheckTimeout = Duration.seconds((long)5L);
    @NotNull
    @JsonProperty
    private String healthCheckSubspace = "health-checking";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getClusterFilePath() {
        return this.clusterFilePath;
    }

    public void setClusterFilePath(String clusterFilePath) {
        this.clusterFilePath = clusterFilePath;
    }

    public int getMaxRetriableTransactionAttempts() {
        return this.maxRetriableTransactionAttempts;
    }

    public void setMaxRetriableTransactionAttempts(int maxRetriableTransactionAttempts) {
        this.maxRetriableTransactionAttempts = maxRetriableTransactionAttempts;
    }

    public Duration getInitialTransactionRetryDelay() {
        return this.initialTransactionRetryDelay;
    }

    public void setInitialTransactionRetryDelay(Duration initialTransactionRetryDelay) {
        this.initialTransactionRetryDelay = initialTransactionRetryDelay;
    }

    public Duration getMaxTransactionRetryDelay() {
        return this.maxTransactionRetryDelay;
    }

    public void setMaxTransactionRetryDelay(Duration maxTransactionRetryDelay) {
        this.maxTransactionRetryDelay = maxTransactionRetryDelay;
    }

    public int getDirectoryCacheSize() {
        return this.directoryCacheSize;
    }

    public void setDirectoryCacheSize(int directoryCacheSize) {
        this.directoryCacheSize = directoryCacheSize;
    }

    public String getTraceDirectory() {
        return this.traceDirectory;
    }

    public void setTraceDirectory(String traceDirectory) {
        this.traceDirectory = traceDirectory;
    }

    public String getTraceLogGroup() {
        return this.traceLogGroup;
    }

    public void setTraceLogGroup(String traceLogGroup) {
        this.traceLogGroup = traceLogGroup;
    }

    public Duration getReverseDirectoryMaxTimePerTransaction() {
        return this.reverseDirectoryMaxTimePerTransaction;
    }

    public void setReverseDirectoryMaxTimePerTransaction(Duration reverseDirectoryMaxTimePerTransaction) {
        this.reverseDirectoryMaxTimePerTransaction = reverseDirectoryMaxTimePerTransaction;
    }

    public int getReverseDirectoryMaxRowsPerTransaction() {
        return this.reverseDirectoryMaxRowsPerTransaction;
    }

    public void setReverseDirectoryMaxRowsPerTransaction(int reverseDirectoryMaxRowsPerTransaction) {
        this.reverseDirectoryMaxRowsPerTransaction = reverseDirectoryMaxRowsPerTransaction;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    public Optional<SecurityFactory> getSecurity() {
        return this.security;
    }

    public void setSecurity(Optional<SecurityFactory> security) {
        this.security = security;
    }

    public int getHealthCheckRetries() {
        return this.healthCheckRetries;
    }

    public void setHealthCheckRetries(int healthCheckRetries) {
        this.healthCheckRetries = healthCheckRetries;
    }

    public Duration getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(Duration healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public String getHealthCheckSubspace() {
        return this.healthCheckSubspace;
    }

    public void setHealthCheckSubspace(String healthCheckSubspace) {
        this.healthCheckSubspace = healthCheckSubspace;
    }

    public FDBDatabase build(MetricRegistry metrics, LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks) {
        return this.build(metrics, lifecycle, healthChecks, null, null);
    }

    public FDBDatabase build(MetricRegistry metrics, LifecycleEnvironment lifecycle, HealthCheckRegistry healthChecks, Executor networkExecutor, Executor executor) {
        CompletionExceptionLogHelper.setAddSuppressed((boolean)false);
        FDB fdb = FDB.selectAPIVersion((int)this.apiVersion);
        this.security.filter(SecurityFactory::isEnabled).ifPresent(securityConf -> securityConf.addSecurityConfigurations(fdb.options()));
        FDBDatabaseFactory factory = this.buildFDBDatabaseFactory(networkExecutor, executor);
        String absoluteClusterFilePath = new File(this.clusterFilePath).getAbsolutePath();
        FDBDatabase database = this.buildFDBDatabase(factory, absoluteClusterFilePath);
        FDBDatabase instrumentedDatabase = this.instrumentFDBDatabase(factory, absoluteClusterFilePath, database, metrics);
        this.registerHealthCheck(healthChecks, database);
        this.manageFDBDatabase(lifecycle, database);
        log.info("Finished setting up record layer database={}", (Object)this.name);
        return instrumentedDatabase;
    }

    protected FDBDatabaseFactory buildFDBDatabaseFactory(Executor networkExecutor, Executor executor) {
        FDBDatabaseFactory factory = FDBDatabaseFactory.instance();
        factory.setMaxAttempts(this.maxRetriableTransactionAttempts);
        factory.setInitialDelayMillis(this.initialTransactionRetryDelay.toMilliseconds());
        factory.setMaxDelayMillis(this.maxTransactionRetryDelay.toMilliseconds());
        factory.setDirectoryCacheSize(this.directoryCacheSize);
        factory.setReverseDirectoryMaxMillisPerTransaction(this.reverseDirectoryMaxTimePerTransaction.toMilliseconds());
        factory.setReverseDirectoryRowsPerTransaction(this.reverseDirectoryMaxRowsPerTransaction);
        factory.setTrace(this.traceDirectory, this.traceLogGroup);
        factory.setDatacenterId(this.dataCenter);
        if (networkExecutor != null) {
            factory.setNetworkExecutor(networkExecutor);
        }
        if (executor != null) {
            factory.setExecutor(executor);
        }
        return factory;
    }

    protected FDBDatabase buildFDBDatabase(FDBDatabaseFactory factory, String absoluteClusterFilePath) {
        return factory.getDatabase(absoluteClusterFilePath);
    }

    protected FDBDatabase instrumentFDBDatabase(FDBDatabaseFactory factory, String absoluteClusterFilePath, FDBDatabase database, MetricRegistry metrics) {
        return new InstrumentedFDBDatabase(factory, absoluteClusterFilePath, database, metrics, this.name);
    }

    protected void registerHealthCheck(HealthCheckRegistry healthChecks, FDBDatabase database) {
        FoundationDBHealthCheck healthCheck = new FoundationDBHealthCheck(database.database(), this.name, this.healthCheckSubspace, this.healthCheckTimeout, this.healthCheckRetries);
        healthChecks.register(this.name, (HealthCheck)healthCheck);
    }

    protected void manageFDBDatabase(LifecycleEnvironment lifecycle, FDBDatabase database) {
        lifecycle.manage((Managed)new RecordLayerManager(database, this.name));
    }
}

