/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb.health;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.tuple.Tuple;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.util.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoundationDBHealthCheck
extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(FoundationDBHealthCheck.class);
    private final Database database;
    private final String name;
    private final String subspacePath;
    private final Duration timeout;
    @Min(value=0L)
    private final @Min(value=0L) int retries;

    public FoundationDBHealthCheck(Database database, String name, String subspacePath, Duration timeout, @Min(value=0L) @Min(value=0L) int retries) {
        this.database = Objects.requireNonNull(database);
        this.name = Objects.requireNonNull(name);
        this.subspacePath = Objects.requireNonNull(subspacePath);
        this.timeout = Objects.requireNonNull(timeout);
        this.retries = retries;
    }

    protected HealthCheck.Result check() {
        try {
            String key = UUID.randomUUID().toString();
            byte[] result = (byte[])((CompletableFuture)this.database.read(transaction -> {
                transaction.options().setTimeout(this.timeout.toMilliseconds());
                transaction.options().setRetryLimit((long)this.retries);
                return transaction.get(Tuple.from((Object[])new Object[]{this.subspacePath, key}).pack());
            })).join();
            log.debug("Health check against FoundationDB successful for database={} result={}", (Object)this.name, (Object)result);
            return HealthCheck.Result.healthy();
        }
        catch (FDBException e) {
            log.warn("FDB error caused health check to fail for database={} with error code={}", new Object[]{this.name, e.getCode(), e});
            return HealthCheck.Result.unhealthy((String)"Exception causing health check failure", (Object[])new Object[]{e});
        }
        catch (Exception e) {
            log.warn("Unable to perform a health check against database={}", (Object)this.name, (Object)e);
            return HealthCheck.Result.unhealthy((String)"Exception causing health check failure", (Object[])new Object[]{e});
        }
    }
}

