/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb.instrumented;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.DatabaseOptions;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.tuple.Tuple;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class InstrumentedDatabase
implements Database {
    private final Database database;
    private final MetricRegistry metrics;
    private final String readMetricName;
    private final String readAsyncMetricName;
    private final String runMetricName;
    private final String runAsyncMetricName;

    public InstrumentedDatabase(Database database, MetricRegistry metrics, String name) {
        this.database = database;
        this.metrics = metrics;
        this.readMetricName = MetricRegistry.name((String)name, (String[])new String[]{"read.timeInNanos"});
        this.readAsyncMetricName = MetricRegistry.name((String)name, (String[])new String[]{"readAsync.timeInNanos"});
        this.runMetricName = MetricRegistry.name((String)name, (String[])new String[]{"run.timeInNanos"});
        this.runAsyncMetricName = MetricRegistry.name((String)name, (String[])new String[]{"runAsync.timeInNanos"});
        metrics.register(MetricRegistry.name((String)name, (String[])new String[]{"MainThreadBusyness"}), (Metric)((Gauge)this::getMainThreadBusyness));
    }

    public Transaction createTransaction() {
        return this.database.createTransaction();
    }

    public Transaction createTransaction(Executor e) {
        return this.database.createTransaction(e);
    }

    public Transaction createTransaction(Executor e, EventKeeper ek) {
        return this.database.createTransaction(e, ek);
    }

    public DatabaseOptions options() {
        return this.database.options();
    }

    public double getMainThreadBusyness() {
        return this.database.getMainThreadBusyness();
    }

    public Tenant openTenant(Tuple tenantName) {
        return this.database.openTenant(tenantName);
    }

    public Tenant openTenant(byte[] tenantName, Executor e) {
        return this.database.openTenant(tenantName, e);
    }

    public Tenant openTenant(Tuple tenantName, Executor e) {
        return this.database.openTenant(tenantName, e);
    }

    public Tenant openTenant(byte[] tenantName, Executor e, EventKeeper eventKeeper) {
        return this.database.openTenant(tenantName, e, eventKeeper);
    }

    public Tenant openTenant(Tuple tenantName, Executor e, EventKeeper eventKeeper) {
        return this.database.openTenant(tenantName, e, eventKeeper);
    }

    public <T> T read(Function<? super ReadTransaction, T> retryable, Executor e) {
        try (Timer.Context ignored = this.metrics.timer(this.readMetricName).time();){
            Object object = this.database.read(retryable, e);
            return (T)object;
        }
    }

    public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> retryable, Executor executor) {
        Timer.Context timerCtx = this.metrics.timer(this.readAsyncMetricName).time();
        return this.database.readAsync(retryable, executor).whenComplete((result, error) -> timerCtx.stop());
    }

    public <T> T run(Function<? super Transaction, T> retryable, Executor e) {
        try (Timer.Context ignored = this.metrics.timer(this.runMetricName).time();){
            Object object = this.database.run(retryable, e);
            return (T)object;
        }
    }

    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> retryable, Executor executor) {
        Timer.Context timerCtx = this.metrics.timer(this.runAsyncMetricName).time();
        return this.database.runAsync(retryable, executor).whenComplete((result, error) -> timerCtx.stop());
    }

    public void close() {
        this.database.close();
    }

    public Executor getExecutor() {
        return this.database.getExecutor();
    }
}

