/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb.instrumented;

import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabaseFactory;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.codahale.metrics.MetricRegistry;
import io.dropwizard.foundationdb.instrumented.InstrumentedFDBStoreTimer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentedFDBDatabase
extends FDBDatabase {
    private static final Logger log = LoggerFactory.getLogger(InstrumentedFDBDatabase.class);
    private final MetricRegistry metrics;
    private final FDBDatabase database;
    private final String name;

    public InstrumentedFDBDatabase(FDBDatabaseFactory factory, @Nullable String clusterFile, FDBDatabase database, MetricRegistry metrics, String name) {
        super(factory, clusterFile);
        this.database = Objects.requireNonNull(database);
        this.metrics = Objects.requireNonNull(metrics);
        this.name = Objects.requireNonNull(name);
    }

    public <T> T run(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, Function<? super FDBRecordContext, ? extends T> retriable) {
        if (timer != null) {
            return (T)this.database.run((FDBStoreTimer)new InstrumentedFDBStoreTimer(timer, this.metrics, this.name), mdcContext, retriable);
        }
        return (T)this.database.run(null, mdcContext, retriable);
    }

    public <T> CompletableFuture<T> runAsync(@Nullable FDBStoreTimer timer, @Nullable Map<String, String> mdcContext, Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable) {
        if (timer != null) {
            return this.database.runAsync((FDBStoreTimer)new InstrumentedFDBStoreTimer(timer, this.metrics, this.name), mdcContext, retriable);
        }
        return this.database.runAsync(null, mdcContext, retriable);
    }

    public <T> T asyncToSync(FDBStoreTimer timer, StoreTimer.Wait event, CompletableFuture<T> async) {
        if (timer != null) {
            return (T)this.database.asyncToSync((FDBStoreTimer)new InstrumentedFDBStoreTimer(timer, this.metrics, this.name), event, async);
        }
        return (T)this.database.asyncToSync(null, event, async);
    }

    public <T> CompletableFuture<T> runAsync(Function<? super FDBRecordContext, CompletableFuture<? extends T>> retriable) {
        return this.runAsync(null, null, retriable);
    }
}

