/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb.instrumented;

import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class InstrumentedFDBStoreTimer
extends FDBStoreTimer {
    private final FDBStoreTimer timer;
    private final MetricRegistry metrics;
    private final String name;

    public InstrumentedFDBStoreTimer(FDBStoreTimer timer, MetricRegistry metrics, String name) {
        this.timer = Objects.requireNonNull(timer);
        this.metrics = Objects.requireNonNull(metrics);
        this.name = Objects.requireNonNull(name);
    }

    public void record(StoreTimer.Event event, long timeDifferenceNanos) {
        String metricName = MetricRegistry.name((String)this.name, (String[])new String[]{event.name()});
        this.metrics.timer(metricName).update(timeDifferenceNanos, TimeUnit.NANOSECONDS);
        this.timer.record(event, timeDifferenceNanos);
    }
}

