/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.foundationdb.security;

import com.apple.foundationdb.NetworkOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.foundationdb.security.SecurityFactory;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="multi-file")
public class MultipleFileSecurityFactory
extends SecurityFactory {
    @NotNull
    @JsonProperty
    private String certificateChainFilePath;
    @NotEmpty
    @JsonProperty
    private String keyFilePath;

    public String getCertificateChainFilePath() {
        return this.certificateChainFilePath;
    }

    public void setCertificateChainFilePath(String certificateChainFilePath) {
        this.certificateChainFilePath = certificateChainFilePath;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public void setKeyFilePath(String keyFilePath) {
        this.keyFilePath = keyFilePath;
    }

    @Override
    public void addSecurityConfigurations(NetworkOptions networkOptions) {
        networkOptions.setTLSPassword(this.getPassword());
        networkOptions.setTLSCaPath(this.getCaFilePath());
        if (this.getVerifyPeers() != null) {
            networkOptions.setTLSVerifyPeers(this.getVerifyPeers().getBytes());
        }
        networkOptions.setTLSCertPath(this.getCertificateChainFilePath());
        networkOptions.setTLSKeyPath(this.getKeyFilePath());
    }
}

