/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.bitmap;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.ConciseBitmapFactory;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.collections.bitmap.RoaringBitmapFactory;
import io.druid.collections.bitmap.WrappedRoaringBitmap;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.roaringbitmap.IntIterator;

public class RoaringBitmapFactoryTest {
    @Test
    public void testIssue26() throws Exception {
        this.checkEmptyComplement((BitmapFactory)new ConciseBitmapFactory());
        this.checkEmptyComplement((BitmapFactory)new RoaringBitmapFactory());
    }

    private void checkEmptyComplement(BitmapFactory bitmapFactory) throws Exception {
        int numRow = 5104234;
        ImmutableBitmap bitmap = bitmapFactory.complement(bitmapFactory.makeEmptyImmutableBitmap(), numRow);
        ImmutableBitmap notBitmap = bitmapFactory.complement(bitmap, numRow);
        Assert.assertTrue((notBitmap.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)notBitmap.isEmpty());
        IntIterator intIter = notBitmap.iterator();
        Assert.assertFalse((boolean)intIter.hasNext());
    }

    @Test
    public void testUnwrapWithNull() throws Exception {
        RoaringBitmapFactory factory = new RoaringBitmapFactory();
        ImmutableBitmap bitmap = factory.union(Iterables.transform((Iterable)Lists.newArrayList((Object[])new WrappedRoaringBitmap[]{new WrappedRoaringBitmap()}), (Function)new Function<WrappedRoaringBitmap, ImmutableBitmap>(){

            public ImmutableBitmap apply(WrappedRoaringBitmap input) {
                return null;
            }
        }));
        Assert.assertEquals((long)0L, (long)bitmap.size());
    }

    @Test
    public void testUnwrapMerge() throws Exception {
        RoaringBitmapFactory factory = new RoaringBitmapFactory();
        WrappedRoaringBitmap set = new WrappedRoaringBitmap();
        set.add(1);
        set.add(3);
        set.add(5);
        ImmutableBitmap bitmap = factory.union(Arrays.asList(factory.makeImmutableBitmap((MutableBitmap)set), null));
        Assert.assertEquals((long)3L, (long)bitmap.size());
    }
}

