/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import io.druid.guice.DruidSecondaryModule;
import io.druid.guice.GuiceInjectors;
import io.druid.guice.JsonConfigProvider;
import org.junit.Assert;
import org.junit.Test;

public class GuiceInjectorsTest {
    @Test
    public void testSanity() {
        Injector stageOne = GuiceInjectors.makeStartupInjector();
        Module module = (Module)stageOne.getInstance(DruidSecondaryModule.class);
        Injector stageTwo = Guice.createInjector((Module[])new Module[]{module, new Module(){

            public void configure(Binder binder) {
                binder.bind(String.class).toInstance((Object)"Expected String");
                JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.", Emitter.class);
                binder.bind(CustomEmitter.class).toProvider((Provider)new CustomEmitterFactory());
            }
        }});
        CustomEmitter customEmitter = (CustomEmitter)stageTwo.getInstance(CustomEmitter.class);
        Assert.assertEquals((Object)"Expected String", (Object)customEmitter.getOtherValue());
    }

    private static class CustomEmitter {
        private Emitter emitter;

        public String getOtherValue() {
            return this.emitter.getValue();
        }

        public CustomEmitter(Emitter emitter) {
            this.emitter = emitter;
        }
    }

    private static class CustomEmitterFactory
    implements Provider<CustomEmitter> {
        private Emitter emitter;

        private CustomEmitterFactory() {
        }

        @Inject
        public void configure(Injector injector) {
            this.emitter = (Emitter)injector.getInstance(Emitter.class);
        }

        public CustomEmitter get() {
            return new CustomEmitter(this.emitter);
        }
    }

    private static class Emitter {
        @JacksonInject
        private String value;

        private Emitter() {
        }

        public String getValue() {
            return this.value;
        }
    }
}

