/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.druid.guice.ConfigModule;
import io.druid.guice.DruidGuiceExtensions;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.PropertiesModule;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.metadata.SegmentMetadataQueryConfig;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class SegmentMetadataQueryConfigTest {
    @Test
    public void testSerdeSegmentMetadataQueryConfig() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new PropertiesModule(Arrays.asList("test.runtime.properties")));
                binder.install((Module)new ConfigModule());
                binder.install((Module)new DruidGuiceExtensions());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.query.segmentMetadata", SegmentMetadataQueryConfig.class);
            }

            @Provides
            @LazySingleton
            public ObjectMapper jsonMapper() {
                return new DefaultObjectMapper();
            }
        }});
        Properties props = (Properties)injector.getInstance(Properties.class);
        SegmentMetadataQueryConfig config = (SegmentMetadataQueryConfig)injector.getInstance(SegmentMetadataQueryConfig.class);
        EnumSet expectedDefaultAnalysis = config.getDefaultAnalysisTypes();
        String actualDefaultAnalysis = props.getProperty("druid.query.segmentMetadata.defaultAnalysisTypes");
        Iterator it = expectedDefaultAnalysis.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (it.hasNext()) {
            SegmentMetadataQuery.AnalysisType e = (SegmentMetadataQuery.AnalysisType)it.next();
            sb.append("\"" + e + "\"");
            if (!it.hasNext()) continue;
            sb.append(',').append(' ');
        }
        sb.append(']');
        String expectedDefaultAnalysisAsString = sb.toString();
        Assert.assertEquals((Object)expectedDefaultAnalysisAsString, (Object)actualDefaultAnalysis);
        Assert.assertEquals((Object)props.getProperty("druid.query.segmentMetadata.defaultHistory"), (Object)config.getDefaultHistory().toString());
    }
}

